{
  description = "xup";

  inputs.nixpkgs.url = "/nix/store/j6j5f4mr0w9y8s2i18mhf4hq5l3rfgw1-source";
  inputs.nix-node-package.url = "/nix/store/qfq8qyvq75zfbzlb9cwxayvnql78mn02-z48a4q2fcw08g414nhfi2ks7nxl4f3jc-source";
  inputs.nix-node-package.inputs.nixpkgs.follows = "nixpkgs";

  # inputs.base.url = "/nix/store/sy9pw1l3963hhvmbn37dzmjj18yww2gz-source";
  # inputs.base.inputs.nixpkgs.follows = "nixpkgs";
  # inputs.base.inputs.xup.follows = "";

  outputs = { self, nixpkgs, nix-node-package /*, base*/ }:

    let
      supportedSystems = [ "x86_64-linux" ];
      forAllSystems = f: nixpkgs.lib.genAttrs supportedSystems (system: f system);
    in

    {
      overlay = final: prev: {
        xup = prev.callPackage ./package.nix {
          mkNode = nix-node-package.lib.nix-node-package prev;
        };
      };

      defaultPackage = forAllSystems (system: (import nixpkgs {
        inherit system;
        overlays = [ self.overlay ];
      }).xup);


      nixosModules.xup = import ./module.nix;

    };
}
