{ config, lib, pkgs, ... }:

with lib;

let
  cfg = config.system.xup;
  xup = pkgs.xup;
in
{
  options = {
    system.xup = {
      enable = mkEnableOption "xup";

      type = mkOption {
        description = "System type";
        type = types.str;
      };

      url = mkOption {
        description = "Update URL";
        type = types.str;
      };

      buildId = mkOption {
        description = "Unique ID of this build";
        type = types.str;
      };

      version = mkOption {
        description = "Human-Readable Version";
        type = types.str;
      };
    };
  };

  config = mkIf (cfg.enable) {
    # backwards compat / accesibility
    environment.etc.build-id.text = cfg.buildId;
    environment.etc.version.text = cfg.version;
    environment.etc.xup-type.text = cfg.type;

    environment.etc."xup.json".text = builtins.toJSON {
      inherit (cfg) url buildId version type;
    };

    systemd.services.xup = with pkgs; {
      startAt = "daily";

      after = [ "network.target" ];
      requires = [ "network-online.target" ];
      path = [ "/run/current-system/sw" ]; # TODO: maybe directly use the packages

      description = "Xeredo Updater Service";
      restartIfChanged = false; # this could interrupt a running update

      serviceConfig = {
        Type = "simple";
        StateDirectory = "xup";
        ExecStart = "${xup}/bin/xup extra cron";
      };
    };

    environment.systemPackages = with pkgs; [
      xup

      (writeShellScriptBin "switch-channel" "set -euo pipefail && ${xup}/bin/xup switch-channel \"$1\"")
      (writeShellScriptBin "check-for-updates" "set -euo pipefail && ${xup}/bin/xup check-update")
      (writeShellScriptBin "update" "set -euo pipefail && ${xup}/bin/xup update")

      git
    ];
  };
}
