#!/nix/store/5mm2f1zqh0n6n0wq6024x001j0bzsc1n-nodejs-17.1.0/bin/node

'use strict'

const fs = require('fs')
const path = require('path')

let cwd = process.env.INIT_CWD || process.cwd()
let pjson

while (!pjson && cwd !== '/') {
  if (fs.existsSync(path.join(cwd, 'package.json'))) {
    pjson = path.join(cwd, 'package.json')
  } else {
    cwd = path.dirname(cwd)
  }
}

if (!pjson) {
  throw new Error('No top-level package.json found!')
}

const { template } = require(pjson)
const e = template.extends
delete template.extends

const { extendRecursivly } = require('.')

extendRecursivly(cwd, template, e)
