import { existsSync, readFileSync, writeFileSync, renameSync } from 'fs'
import dlv from 'dlv'
import { dset } from 'dset'

export default function KV (path) {
  let data

  let corrupted = false

  if (existsSync(path)) {
    try {
      data = JSON.parse(readFileSync(path))
    } catch (error) {
      corrupted = error
    }
  }

  if (existsSync(path + '~') && !data) {
    data = JSON.parse(readFileSync(path + '~'))
  }

  if (!data) {
    if (corrupted) {
      throw corrupted
    }

    data = {}
  }

  function write () {
    renameSync(path, path + '~')
    writeFileSync(path, JSON.stringify(data))
  }

  function set (key, value) {
    dset(data, key, value)
    write()
  }

  function get (key, def) {
    return dlv(data, key, def)
  }

  return {
    get,
    set
  }
}
