#!/nix/store/l0wlqpbsvh1pgvhcdhw7qkka3d31si7k-bash-5.1-p8/bin/bash
set -eu
# if the pstore module is builtin it will have mounted the persistent store automatically. it may also be already mounted for other reasons.
/nix/store/j9qg60v12mm5c0s8xnjsb0gl98ap8zlh-util-linux-2.37.2-bin/bin/mountpoint -q /sys/fs/pstore || /nix/store/j9qg60v12mm5c0s8xnjsb0gl98ap8zlh-util-linux-2.37.2-bin/bin/mount -t pstore -o nosuid,noexec,nodev pstore /sys/fs/pstore
# wait up to 1.5 seconds for the backend to be registered and the files to appear. a systemd path unit cannot detect this happening; and succeeding after a restart would not start dependent units.
TRIES=15
while [ "$(cat /sys/module/pstore/parameters/backend)" = "(null)" ]; do
  if (( $TRIES )); then
    sleep 0.1
    TRIES=$((TRIES-1))
  else
    echo "Persistent Storage backend was not registered in time." >&2
    break
  fi
done

