'use strict'

async function main () {
  const ec = require('@xeredo/easy-crypto')
  // generate some keys
  const pair = ec.generateKeyPair('rsa', 4096)

  const Auth = require('.')
  const client = Auth.client(pair)

  const fetch = require('node-fetch')
  console.log(await (await fetch('http://localhost:3333/registerClient', {
    method: 'POST',
    // export key as PEM
    body: new URLSearchParams({ key: pair.pub.export() })
  })).json())

  // send a signed request
  const req = await fetch(...client.signFetch('http://localhost:3333/hello', 'POST', { name: 'Johnson' }))
  // get result
  const res = await req.json()

  console.log(res)
}

main().then(() => {}, console.error)
