'use strict'

const Hapi = require('@hapi/hapi')
const Auth = require('.')
const Joi = require('joi')
const ec = require('@xeredo/easy-crypto')

const init = async () => {
  const server = Hapi.server({
    port: 3333,
    host: 'localhost',
    debug: { request: ['error'] }
  })

  // you want to use a database instead
  const devices = {}

  await server.register({
    plugin: Auth.hapi
  })

  server.auth.strategy('session', 'crypto-auth', {
    getDevice (fingerprint) {
      console.log('authorizing', fingerprint)
      if (devices[fingerprint]) {
        return devices[fingerprint]
      }
    }
  })
  server.auth.default({
    strategy: 'session',
    payload: true
  })

  server.route({
    method: 'POST',
    path: '/registerClient',
    config: {
      auth: false,
      validate: {
        payload: Joi.object({
          key: Joi.string().required()
        })
      },
      handler: async (request, h) => {
        const key = ec.public.fromBuffer(request.payload.key)
        const fingerprint = key.spkiFingerprint()
        console.log('added device', fingerprint)

        devices[fingerprint] = {
          key,
          credentials: {
            fingerprint,
            // user-id
            id: String(Math.random())
          }
        }

        return { added: fingerprint }
      }
    }
  })

  server.route({
    method: 'POST',
    path: '/hello',
    config: {
      validate: {
        payload: Joi.object({
          name: Joi.string().required()
        })
      },
      handler: async (request, h) => {
        return { msg: `Hello ${request.payload.name}`, credentials: request.auth.credentials }
      }
    }
  })

  await server.start()
  console.log('Server running on %s', server.info.uri)
}

process.on('unhandledRejection', (err) => {
  console.log(err)
  process.exit(1)
})

init()
