import { spawn } from '@xeredo/common/src/modules/util.js'
import path from 'path'
import fs from 'fs'

import _mkdirp from 'mkdirp'
import _rimraf from 'rimraf'
const { sync: mkdirp } = _mkdirp
const { sync: rimraf } = _rimraf

const CONFIG_HOME = '/etc/ssl/letsencrypt'
const markerNotice = 'This certificate is managed by Guardian and will be automatically removed once it is no longer required!'

async function acmeAdd (certId, domains, pipeline) {
  // our patch
  return acme(
    pipeline,
    { DOMAIN_CERT_ID: certId, DEBUG: '0' },
    '--config-home', CONFIG_HOME,
    '--issue',
    ...domains.map(d => ['--domain', d]).reduce((a, b) => a.concat(b), []),
    // '--reloadcmd', 'systemctl reload nginx',
    '--server', 'letsencrypt',
    '--webroot', '/tmp'
  )
}

async function acme (pipeline, env, ...args) {
  return spawn('acme.sh', [...args], false, false, {
    env: Object.assign({}, process.env, {
      // fix some edge cases
      SUDO_COMMAND: '',
      SUDO_USER: '',
      SUDO_UID: '',
      SUDO_GID: '',
      // other options
      ...env
    })
  }, pipeline)
}

export default async ({ certs, forceRenew = false, cleanup = false, issue = true, pipeline }) => {
  /*

  namings:
    - for domain certs: domain name
    - for specially crafted input certs serviceId.inputName

  */

  const out = {}

  if (issue) {
    for (const cert in certs) { // eslint-disable-line guard-for-in
      const domains = certs[cert]

      if (!domains.length) { // skip empty
        continue
      }

      const marker = path.join(CONFIG_HOME, cert, '.managed')
      if (!fs.existsSync(marker)) {
        mkdirp(path.dirname(marker))
        fs.writeFileSync(marker, markerNotice)
      }

      await acmeAdd(cert, domains.sort(), pipeline)

      out[cert] = {
        cert: path.join(CONFIG_HOME, cert, 'fullchain.cer'),
        key: path.join(CONFIG_HOME, cert, `${cert}.key`)
      }
    }
  }

  if (cleanup) {
    fs.readdirSync(CONFIG_HOME)
      .filter(dir => fs.existsSync(path.join(CONFIG_HOME, dir, '.managed'))) // take all certs we manage(d)
      .filter(dir => !certs[dir]) // get all the no longer exist
      .forEach(dir => rimraf(path.join(CONFIG_HOME, dir))) // and purge them
  }

  return out
}
