/* eslint-disable no-negated-condition */

/* eslint-disable complexity */

import {
  getType,
  getSType,
  getInstance
} from './types.js'

import aquireCerts from './aquire-certs.js'

import path from 'path'

import * as verify from '../verify/index.js'
import Util from '../config/util.js'

import { fileURLToPath } from 'url'

import debug from 'debug'
const log = debug('guardian:config:pregen')
const __dirname = path.dirname(fileURLToPath(import.meta.url))

function getCommonDomain (names, dList) {
  const domains = Object.values(dList).map(d => d.name).map(n => n.split('.'))

  const usedDomains = []

  names.forEach(name => {
    const s = name.split('.')

    const used = domains.filter(d => {
      // copy the X things before the domain name, join into name
      const nameNormal = s.slice(0).reverse().slice(0, d.length).reverse().join('.')
      // turn domain into string
      const domainNormal = d.join('.')

      return domainNormal === nameNormal
    })

    // add new
    used.forEach(name => {
      name = name.join('.')
      if (usedDomains.indexOf(name) === -1) {
        usedDomains.push(name)
      }
    })
  })

  // if just one, return that - else return false
  if (usedDomains.length === 1) {
    return usedDomains[0]
  }

  return false
}

export default async (storage, { justDomainList, justDescribe, justVerify, pipeline } = {}) => {
  storage = storage.sub(['guardian'])

  const domains = await storage.sub(['domains']).get()
  const services = await storage.sub(['services']).get()

  const inputCache = {}
  const certs = {}

  const out = {
    domains: {},
    services: []
  }

  // process all domains
  for (const did in domains) { // eslint-disable-line guard-for-in
    const domain = domains[did]

    const dOut = {
      name: domain.name,
      certSub: [],
      routes: []
    }

    certs[domain.name] = []

    // process every route
    for (const id in domain.routes) { // eslint-disable-line guard-for-in
      const route = domain.routes[id]

      if (route.type !== 'link') { // ignore links - link just shows a service is using this sub
        const typeObj = getType(route.type)
        const typeInstance = getInstance(id, typeObj, () => storage.sub(['domains', did, 'routes', id, 'config']).get())

        const req = typeInstance.requires()
        // TODO: req.domains
        // TODO: req.certs

        const certDomain = route.dest === '@' ? domain.name : `${route.dest}.${domain.name}`

        if (!req.certs) {
          req.certs = {
            cert: [certDomain]
          }
        }

        let full = domain.name

        if (route.dest && route.dest !== '@') {
          full = `${route.dest}.${domain.name}`
        }

        inputCache[id] = {
          req,
          typeInstance,
          type: route.type,
          extra: {
            domain: domain.name,
            sub: route.dest,
            full
          }
        }
      }
    }
  }

  // process all services (domain-independent)
  for (const id in services) { // eslint-disable-line guard-for-in
    const service = services[id]

    const sOut = {
      type: service.type
    }

    const typeObj = getSType(service.type)
    const typeInstance = getInstance(id, typeObj, () => storage.sub(['services', id, 'config']).get())

    const req = typeInstance.requires()
    // TODO: req.domains
    // TODO: req.certs

    inputCache[id] = { req, typeInstance, type: service.type }
  }

  // here we process all the inputs to pre-map (.req -> .resPreMap)
  for (const inputId in inputCache) { // eslint-disable-line guard-for-in
    const { req } = inputCache[inputId]

    const resPreMap = {}

    // this instance requests certificates to be issued
    // we should map them to either matching certificates we already have
    // or map them to new certificates for issuance
    if (req.certs) {
      resPreMap.certs = {}

      for (const certId in req.certs) { // eslint-disable-line guard-for-in
        const cert = req.certs[certId]

        const commonDomain = getCommonDomain(cert, domains)

        if (!commonDomain) { // we don't have a common domain, this certificate needs to be issued seperately
          const newCertID = `${inputId}.${certId}`
          certs[newCertID] = cert
          resPreMap.certs[certId] = newCertID
        } else { // we have a common domain
          cert.forEach(domain => {
            if (certs[commonDomain].indexOf(domain) === -1) { // add all subs that don't exist
              certs[commonDomain].push(domain)
            }
          })
          resPreMap.certs[certId] = commonDomain
        }
      }
    }

    inputCache[inputId].resPreMap = resPreMap
  }

  if (justDescribe) {
    const out = {}

    for (const key in inputCache) { // eslint-disable-line guard-for-in
      try {
        out[key] = inputCache[key].typeInstance.describe(inputCache[key].extra || {})
      } catch (error) {
        log(error)
        // this shouldn't ever fail fetching config, so just ignore errors
      }
    }

    return out
  }

  if (justVerify) {
    const out = {
      result: []
    }

    for (const did in domains) { // eslint-disable-line guard-for-in
      const domain = domains[did]

      const outD = {
        displaySelf: domain.name,
        sub: []
      }
      out.result.push(outD)

      for (const id in domain.routes) { // eslint-disable-line guard-for-in
        const route = domain.routes[id]

        if (route.type !== 'link') {
          try {
            const res = await inputCache[id].typeInstance.verify(verify, inputCache[id].extra || {})
            const el = {
              displaySelf: route.dest,
              sub: Array.isArray(res) ? res : [res],
              localeScope: {
                route: inputCache[id].type
              }
            }
            processSub(el)
            outD.sub.push(el)
          } catch (error) {
            outD.sub.push({
              display: ['verify.item', route.dest, ['verify.summary.not_reachable_desc', String(error)]],
              state: 'failure',
              success: false,
              localeScope: {
                route: inputCache[id].type
              }
            })
            log(error)
            // this shouldn't ever fail
          }
        }
      }
    }

    const outS = {
      displaySelf: ['proxy.services'],
      sub: []
    }
    out.result.push(outS)

    for (const id in services) { // eslint-disable-line guard-for-in
      const service = services[id]

      try {
        const res = await inputCache[id].typeInstance.verify(verify, inputCache[id].extra || {})
        const el = {
          displaySelf: [getSType(inputCache[id].type).name],
          sub: Array.isArray(res) ? res : [res],
          localeScope: {
            service: inputCache[id].type
          }
        }
        processSub(el)
        outS.sub.push(el)
      } catch (error) {
        outS.sub.push({
          display: ['verify.item', [getSType(inputCache[id].type).name], ['verify.summary.not_reachable_desc', String(error)]],
          state: 'failure',
          success: false,
          localeScope: {
            service: inputCache[id].type
          }
        })
        log(error)
      }
    }

    function processSub (e) {
      if (e.sub.length) {
        e.success = e.sub.reduce((a, b) => a && b.success, true)
        e.state = e.success ? 'success' : 'failure'
        e.display = ['verify.item', e.displaySelf, e.success ? ['verify.summary.reachable'] : ['verify.summary.not_reachable']]
      } else {
        e.success = true
        e.state = 'neutral'
        e.display = ['verify.item', e.displaySelf, ['verify.summary.no_checks']]
      }
    }

    out.result.forEach(processSub)

    out.success = out.result.reduce((a, b) => a && b.success, true)

    return out
  }

  if (justDomainList) {
    const _u = {}
    return {
      domains: Object.values(certs).flat().filter(v => _u[v] ? false : (_u[v] = true)),
      certs
    }
  }

  // issue all the certs
  const issuedCerts = await aquireCerts({ certs, cleanup: true, issue: true, pipeline })

  // here we actually process the inputs, by getting the results and connecting via pre-map
  for (const inputId in inputCache) { // eslint-disable-line guard-for-in
    const { resPreMap } = inputCache[inputId]

    const res = {}

    if (resPreMap.certs) {
      res.certs = {}

      for (const outId in resPreMap.certs) { // eslint-disable-line guard-for-in
        const certId = resPreMap.certs[outId]

        res.certs[outId] = issuedCerts[certId]
      }
    }

    inputCache[inputId].res = res
  }

  // use processed inputs and use the outputs to generate the actual nginx config per plugin
  const configs = []

  for (const inputId in inputCache) { // eslint-disable-line guard-for-in
    const { typeInstance, res, type, extra = {} } = inputCache[inputId]

    if (res.certs.cert) {
      extra.cert = res.certs.cert
    }

    const config = await typeInstance.configure({ ...res, ...extra }, Util({ pluginPath: path.join(__dirname, '..', 'config', 'modules', type) }))

    configs.push(config)
  }

  return configs
}
