import { info, error } from '@xeredo/common/src/modules/util'

export default ({ long, client, extraHandlers, $t }) => {
  const url = '/long/' + long.id

  return new Promise((resolve, reject) => {
    client.subscribe(url, async e => {
      if (e.ev === 'done') {
        await client.unsubscribe(url)
        if (e.error) {
          reject(new Error(e.error))
        } else {
          resolve()
        }
      } else if (e.ev === 'log') {
        process.stdout.write(e.data + '\n')
      } else if (e.ev === 'stdout') {
        process.stdout.write(Buffer.from(e.data, 'hex'))
      } else if (e.ev === 'stderr') {
        process.stderr.write(Buffer.from(e.data, 'hex'))
      } else if (e.ev === 'info') {
        info(...e.data)
      } else if (e.ev === 'error') {
        error(...e.data)
      } else if (e.ev === 'info$t') {
        info($t(...e.data))
      } else if (e.ev === 'error$t') {
        error($t(...e.data))
      } else if (extraHandlers[e.ev]) {
        await extraHandlers[e.ev](e)
      }
    })
  })
}
