import Controller from './instance-controller.js'

const gt = async name => ({ [name]: await import('../config/modules/' + name + '/index.js') })

const Types = {
  ...await gt('custom-config'),
  ...await gt('generic-http'),
  ...await gt('groupwise-messenger-tls-terminator'),
  ...await gt('ldap-tls-terminator'),
  ...await gt('microsoft-exchange'),
  ...await gt('webinterface')
}

const c = Controller()

const types = Object.keys(Types).map(typeId => [typeId, Types[typeId].route]).filter(t => Boolean(t[1])).reduce((out, t) => {
  out[t[0]] = t[1]
  t[1].id = t[0]
  return out
}, {})
const stypes = Object.keys(Types).map(typeId => [typeId, Types[typeId].service]).filter(t => Boolean(t[1])).reduce((out, t) => {
  out[t[0]] = t[1]
  t[1].id = t[0]
  return out
}, {})

export function getTypes () {
  return Object.keys(types)
}
export function getType (type) {
  return types[type]
}
export function getSTypes () {
  return Object.keys(stypes)
}
export function getSType (type) {
  return stypes[type]
}
export function getInstance (id, typeObj, config) {
  return c.spawnInstance(id, typeObj.create, config)
}
