import Boom from '@hapi/boom'
import Joi from 'joi'

// from npm.im/nuisance

export default {
  pkg: {
    name: 'multiauth',
    version: '1'
  },
  requirements: {
    hapi: '>=18.4.0'
  },
  register: (server, options) => {
    server.auth.scheme('multiauth', multiauthScheme)
  }
}

const schema = Joi.object({
  strategies: Joi.array().items(
    Joi.string().description('strategy name')
  ).min(1).required().description('strategies to aggregate')
})

function multiauthScheme (server, options) {
  Joi.assert(options, schema)

  return {
    authenticate: async function (request, h) {
      for (let i = 0; i < options.strategies.length; i++) {
        const strategy = options.strategies[i]

        try {
          const res = await server.auth.test(strategy, request)
          res.credentials.strategy = strategy
          return h.authenticated(res)
        } catch (error) {
          // do nothing
        }
      }

      return h.unauthenticated(Boom.unauthorized('No valid credentials supplied'))
    }
  }
}
