import Joi from 'joi'
import SessionCookie from './session-cookie.js'

export default {
  pkg: {
    name: 'cli-auth',
    version: '1'
  },
  requirements: {
    hapi: '>=18.4.0'
  },
  register: (server, options) => {
    server.auth.scheme('cli-auth', implementation)
  }
}

const schema = Joi.object({
  cookieFolder: Joi.string().required()
})

const implementation = (server, options) => {
  const { value: { cookieFolder }, error } = schema.validate(options)
  if (error) {
    throw error
  }

  const checkSession = SessionCookie(cookieFolder).authenticate

  return {
    authenticate: (request, h) => {
      const cookie = request.headers['x-cli-cookie']

      return checkSession(cookie, h)
    }
  }
}
