import crypto from 'crypto'
import path from 'path'
import os from 'os'
import fs from 'fs'

export default base => {
  const cookies = path.join(base, '.cli-cookie')

  const cookie = crypto.randomBytes(16).toString('hex')

  try {
    fs.writeFileSync(path.join(cookies, cookie), `${os.userInfo().username}\t${process.pid}\t${Date.now()}`)
  } catch (error) {
    if (error.code === 'EPERM') {
      throw new Error('Current user has no permission to use this command')
    } else {
      throw new Error('Failed to create CLI cookie: ' + error)
    }
  }

  return {
    cookie,
    headers: {
      'x-cli-cookie': cookie
    }
  }
}
