import fetch from 'node-fetch'

export default (url, extraHeaders = {}) => {
  async function req (method, body) {
    const req = await fetch(url, {
      method,
      body: JSON.stringify(body),
      headers: { 'Content-Type': 'application/json', ...extraHeaders }
    })

    const res = await req.json()

    return res
  }

  return {
    get: async (path, def) => {
      const v = (await req('POST', { path })).res
      if (v === undefined) { // FIXME: hapi won't allow this
        return def
      }
      return v
    },
    set: async (path, value) => {
      return (await req('PUT', { path, value })).res
    },
    del: async path => {
      return (await req('DELETE', path)).res
    }
  }
}
