import fs from 'fs'

import dlv from 'dlv'
import { dset } from 'dset'

export default file => {
  function doSave () {
    if (fs.existsSync(file)) {
      fs.renameSync(file, bakFile)
    }

    fs.writeFileSync(file, JSON.stringify(data))
    saveTimeout = null
  }

  let saveTimeout

  function save () {
    if (saveTimeout) {
      return
    }

    saveTimeout = setTimeout(doSave, 5000)
  }

  const bakFile = file + '~'

  if (!fs.existsSync(file)) {
    if (fs.existsSync(bakFile)) {
      fs.renameSync(bakFile, file)
    }
  }

  let data = {}

  if (fs.existsSync(file)) {
    try {
      data = JSON.parse(fs.readFileSync(file))
    } catch (error) {
      data = JSON.parse(fs.readFileSync(bakFile))
    }
  }

  return {
    get: (path, def) => {
      return dlv(data, path, def)
    },
    set: (path, value) => {
      dset(data, path, value)
      save()
    },
    del: path => {
      const current = data
      path = path.reverse()

      const target = path.pop()

      while (path.length) {
        const el = path.pop()
        if (!current[el]) {
          return false
        }
      }

      delete current[target]

      save()
    }
  }
}
