import Boom from '@hapi/boom'
import Joi from 'joi'

export default {
  pkg: {
    name: 'token-auth',
    version: '1'
  },
  requirements: {
    hapi: '>=18.4.0'
  },
  register: (server, options) => {
    server.auth.scheme('token-auth', implementation)
  }
}

const tokenSchema = Joi.string().hex().required()

const schema = Joi.object({
  verifyToken: Joi.function().required()
})

const implementation = (server, options) => {
  const { value: { verifyToken }, error } = schema.validate(options)
  if (error) {
    throw error
  }

  return {
    authenticate: async (request, h) => {
      const { error, value: token } = tokenSchema.validate(request.headers['x-token'])
      if (error) {
        throw error
      }

      const creds = await verifyToken(token)

      if (!creds) {
        throw Boom.unauthorized('Token unknown')
      }

      return h.authenticated({
        credentials: creds.credentials || {},
        artifacts: creds.artifacts
      })
    }
  }
}
