import locales from './locales/index.js'

export const route =
   {
     name: 'custom.name',
     desc: 'custom.desc',
     locales,
     config: {
       content: {
         display: 'custom.text',
         type: 'nano',
         default: `server {
  listen 443 ssl http2;
  listen [::]:443 ssl http2;

  # This is automatically replaced by the SSL certificate & key location
  # You shouldn't edit this
  include _/modern-ssl.conf;
  ssl_certificate {CERT};
  ssl_certificate_key {KEY};

  # This is automatically replaced by the route name
  # You can also add other names here if you want
  server_name {NAME};

  location / {
    # Pass requests to destination server
    proxy_pass       https://SERVER_IP$request_uri;
    proxy_ssl_verify off;
    proxy_set_header Host            $host;
    proxy_set_header X-Forwarded-For $remote_addr;
    proxy_pass_request_headers on;
  }
}`
       }
     },
     create (getConfig) {
       return {
         requires () {
           return {}
         },

         describe () {
           return ['custom.name']
         },

         verify () {
           return []
         },

         // since this is a route, we get the domain, sub, cert predefined, but we can request extra certs if needed
         configure ({ cert: serviceCert, full }, { fromTemplate }) {
           const { cert, key } = serviceCert
           const { content } = getConfig()

           const vars = {
             CERT: cert,
             KEY: key,
             NAME: full
           }

           return {
             nginx: {
               sites: {
                 ['custom-' + full + '.conf']: content.replace(/\{([A-Z]+)\}/g, (_, v) => vars[v])
               }
             },
             firewall: []
           }
         }
       }
     }
   }
