import locales from './locales/index.js'

export const route =
   {
     name: 'generic.name',
     desc: 'generic.desc',
     locales,
     config: {
       targetHost: {
         display: 'generic.host',
         type: 'host',
         required: true
       },
       targetPort: {
         display: 'generic.port',
         type: 'port',
         required: true
       },
       useSSL: {
         display: 'generic.ssl',
         type: 'bool',
         default: false
       },
       verifySSL: {
         display: 'generic.verifyssl',
         type: 'bool',
         default: false
       }
     },
     create (getConfig) {
       function getURL() {
         const { targetHost, targetPort, useSSL } = getConfig()
         return `${useSSL ? 'https' : 'http'}://${targetHost}:${targetPort}`
       }

       return {
         requires () {
           return {}
         },

         describe ({ full }) {
           return ['generic.describe', getURL(), full]
         },

         verify (verify) {
           return verify.verifyURL(getURL())
         },

         // since this is a route, we get the domain, sub, cert predefined, but we can request extra certs if needed
         configure ({ cert: serviceCert, full }, { fromTemplate }) {
           const { cert, key } = serviceCert
           const { verifySSL } = getConfig()

           return {
             nginx: {
               sites: {
                 ['generic-' + full + '.conf']: fromTemplate('generic.conf', {
                   CERT: cert,
                   KEY: key,
                   NAME: full,
                   URL: getURL(),
                   VERIFY_SSL: verifySSL ? 'on' : 'off'
                 })
               }
             },
             firewall: []
           }
         }
       }
     }
   }
