import locales from './locales/index.js'

/*

init_module "gw"        "Groupwise Messenger"

gw_configure() {
  expose_var GW_IP "$(_db gw_ip)"
  generate_file "modules/groupwise-messenger-tls-terminator/template/groupwise.conf" "/etc/nginx/stream.d/groupwise.conf"

  ufw allow 8300/tcp comment "Groupwise Messenger"
}

gw_setup() {
  prompt gw_ip "Groupwise Messenger IP"
}

gw_disable() {
  ufw delete allow 8300/tcp
  rm -f /etc/nginx/stream.d/groupwise.conf
}

*/

export const service = {
  name: 'groupwise.name',
  desc: 'groupwise.desc',
  locales,
  config: {
    /*
      display: translationId,
      type: type,
      promptType?: promptType,
      required?: required || true,
      if: condition (Joi) ?,
        {
          gwIp: Joi.string().values(bla)
        }
      */
    gwIp: {
      display: 'groupwise.host',
      type: 'host',
      required: true
    },
    gwSub: {
      display: 'groupwise.sub',
      type: 'string',
      default: 'messenger',
      required: true
    },
    gwDomain: {
      display: 'groupwise.domain',
      type: 'domain',
      required: true
    }
  },
  create (getConfig) {
    return {
      requires () {
        const { gwDomain, gwSub } = getConfig()

        const domain = `${gwSub}.${gwDomain}`

        return {
          certs: { // require serviceCert be a certificate that has "$domain" in it's list
            serviceCert: [domain] // NOTE: if there are different domains (gw.domain.de, gw.other-domain.de) (not just different subdomains) then guardian will make LE issue a seperate certificate
          },
          domains: { // require $gwDomain should have $gwSub
            [gwDomain]: {
              [gwSub]: [
                { type: 'link' } // TODO: this is a special type that basically makes this instance be a link that you can click on that gets you to this service
              ]
            }
          }
        }
      },

      describe () {
        const { gwDomain, gwSub, gwIp } = getConfig()
        return ['groupwise.describe', gwIp, `${gwSub}.${gwDomain}`]
      },

      verify (verify) {
        const { gwIp } = getConfig()

        return verify.verifyNet(gwIp, 8300)
      },

      configure ({ certs: { serviceCert } }, { fromTemplate }) {
        const { cert, key } = serviceCert
        const { gwIp } = getConfig()

        return {
          nginx: {
            'stream.d': {
              'groupwise.conf': fromTemplate('groupwise.conf', {
                CERT: cert,
                KEY: key,
                GW_IP: gwIp
              })
            }
          },
          firewall: [
            ['8300', 'tcp', 'Groupwise Messenger']
          ]
        }
      }
    }
  }
}
