import locales from './locales/index.js'

/*

#!/bin/bash

# @doc:     <plugin-id> <name>
init_module "ldaps"        "LDAP-over-TLS"

ldaps_configure() {
  expose_var LDAP_IP "$(_db ldap_ip)"
  expose_var LDAP_PORT "$(_db ldap_port)"
  expose_var LDAP_SSL "$(_db ldap_ssl)"
  generate_file "modules/ldap-tls-terminator/template/ldaps.conf" "/etc/nginx/stream.d/ldaps.conf"

  ufw allow 636/tcp comment "LDAP SSL"
}

ldaps_setup() {
  prompt ldap_ip "LDAP-Server IP"
  prompt ldap_port "LDAP-Server Port" 636
  prompt ldap_ssl "TLS für den Zugriff auf den Zielserver verwenden? (on/off)" on
}

ldaps_disable() {
  ufw delete allow 636/tcp
  rm -f /etc/nginx/stream.d/ldaps.conf
}

*/

export const service = {
  name: 'ldap.name',
  desc: 'ldap.desc',
  locales,
  config: {
    /*
      display: translationId,
      type: type,
      promptType?: promptType,
      required?: required || true,
      if: condition (Joi) ?,
        {
          gwIp: Joi.string().values(bla)
        }
      */
    ldapIp: {
      display: 'ldap.address',
      type: 'host',
      required: true
    },
    ldapPort: {
      display: 'ldap.port',
      type: 'port'
    },
    ldapTls: {
      display: 'ldap.tls',
      type: 'bool'
    },
    ldapDomain: {
      display: 'ldap.domain',
      type: 'domain'
    },
    ldapSub: {
      display: 'ldap.sub',
      type: 'string',
      required: false
    }
  },
  create (getConfig) {
    return {
      requires () {
        const { ldapDomain, ldapSub } = getConfig()

        const domain = ldapSub ? `${ldapSub}.${ldapDomain}` : ldapDomain

        return {
          certs: { // require serviceCert be a certificate that has "$domain" in it's list
            serviceCert: [domain] // NOTE: if it includes two different domains then the cert will be issued like so that we have them in both...
          },
          domains: { // require $gwDomain should have $gwSub
            [ldapDomain]: {
              [ldapSub || '']: [
                { type: 'link' } // TODO: this is a special type that basically makes this instance be a link that you can click on that gets you to this service
              ]
            }
          }
        }
      },

      verify (verify) {
        const { ldapIp, ldapPort = 636 } = getConfig()

        return verify.verifyNet(ldapIp, ldapPort)
      },

      configure ({ certs: { serviceCert } }, { fromTemplate }) {
        const { cert, key } = serviceCert
        const { ldapIp, ldapPort, ldapTls } = getConfig()

        return {
          nginx: {
            'stream.d': {
              'ldaps.conf': fromTemplate('ldaps.conf', {
                CERT: cert,
                KEY: key,
                LDAP_IP: ldapIp,
                LDAP_PORT: ldapPort || 636,
                LDAP_TLS: ldapTls ? 'on' : 'off'
              })
            }
          },
          firewall: [
            ['636', 'tcp', 'LDAPS']
          ]
        }
      }
    }
  }
}
