import locales from './locales/index.js'

export const route = {
  name: 'webinterface.name',
  desc: 'webinterface.desc',
  locales,
  config: {
    subdir: {
      display: 'webinterface.subdir',
      type: 'path',
      default: '/'
    }
  },
  create (getConfig) {
    return {
      requires () {
        return {}
      },

      describe ({ full }) {
        const { subdir } = getConfig()
        return ['webinterface.describe', full, subdir]
      },

      verify (verify) {
        return verify.verifyURL('http://localhost:3333')
      },

      // since this is a route, we get the domain, sub, cert predefined, but we can request extra certs if needed
      configure ({ cert: serviceCert, full }, { fromTemplate }) {
        const { cert, key } = serviceCert
        const { subdir } = getConfig()

        return {
          nginx: {
            sites: {
              ['webinterface-' + full + '.conf']: fromTemplate('webinterface.conf', {
                CERT: cert,
                KEY: key,
                NAME: full,
                SUBDIR: subdir
              })
            }
          },
          firewall: []
        }
      }
    }
  }
}
