# Vulnerability Roundup {#chap-vulnerability-roundup}

## Issues {#vulnerability-roundup-issues}

Vulnerable packages in Nixpkgs are managed using issues.
Currently opened ones can be found using the following:

[github.com/NixOS/nixpkgs/issues?q=is:issue+is:open+"Vulnerability+roundup"](https://github.com/NixOS/nixpkgs/issues?q=is%3Aissue+is%3Aopen+%22Vulnerability+roundup%22)

Each issue correspond to a vulnerable version of a package; As a consequence:

- One issue can contain several CVEs;
- One CVE can be shared across several issues;
- A single package can be concerned by several issues.


A "Vulnerability roundup" issue usually respects the following format:

```txt
<link to relevant package search on search.nix.gsc.io>, <link to relevant files in Nixpkgs on GitHub>

<list of related CVEs, their CVSS score, and the impacted NixOS version>

<list of the scanned Nixpkgs versions>

<list of relevant contributors>
```

Note that there can be an extra comment containing links to previously reported (and still open) issues for the same package.


## Triaging and Fixing {#vulnerability-roundup-triaging-and-fixing}

**Note**: An issue can be a "false positive" (i.e. automatically opened, but without the package it refers to being actually vulnerable).
If you find such a "false positive", comment on the issue an explanation of why it falls into this category, linking as much information as the necessary to help maintainers double check.

If you are investigating a "true positive":

- Find the earliest patched version or a code patch in the CVE details;
- Is the issue already patched (version up-to-date or patch applied manually) in Nixpkgs's `master` branch?
  - **No**:
    - [Submit a security fix](#submitting-changes-submitting-security-fixes);
    - Once the fix is merged into `master`, [submit the change to the vulnerable release branch(es)](https://nixos.org/manual/nixpkgs/stable/#submitting-changes-stable-release-branches);
  - **Yes**: [Backport the change to the vulnerable release branch(es)](https://nixos.org/manual/nixpkgs/stable/#submitting-changes-stable-release-branches).
- When the patch has made it into all the relevant branches (`master`, and the vulnerable releases), close the relevant issue(s).
