# Release 20.03 ("Markhor", 2020.04/20) {#sec-release-20.03}

## Highlights {#sec-release-20.03-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Support is planned until the end of October 2020, handing over to 20.09.

- Core version changes:

  gcc: 8.3.0 -\> 9.2.0

  glibc: 2.27 -\> 2.30

  linux: 4.19 -\> 5.4

  mesa: 19.1.5 -\> 19.3.3

  openssl: 1.0.2u -\> 1.1.1d

- Desktop version changes:

  plasma5: 5.16.5 -\> 5.17.5

  kdeApplications: 19.08.2 -\> 19.12.3

  gnome3: 3.32 -\> 3.34

  pantheon: 5.0 -\> 5.1.3

- Linux kernel is updated to branch 5.4 by default (from 4.19).

- Grub is updated to 2.04, adding support for booting from F2FS filesystems and Btrfs volumes using zstd compression. Note that some users have been unable to boot after upgrading to 2.04 - for more information, please see [this discussion](https://github.com/NixOS/nixpkgs/issues/61718#issuecomment-617618503).

- Postgresql for NixOS service now defaults to v11.

- The graphical installer image starts the graphical session automatically. Before you\'d be greeted by a tty and asked to enter `systemctl start display-manager`. It is now possible to disable the display-manager from running by selecting the `Disable display-manager` quirk in the boot menu.

- GNOME 3 has been upgraded to 3.34. Please take a look at their [Release Notes](https://help.gnome.org/misc/release-notes/3.34) for details.

- If you enable the Pantheon Desktop Manager via [services.xserver.desktopManager.pantheon.enable](options.html#opt-services.xserver.desktopManager.pantheon.enable), we now default to also use [ Pantheon\'s newly designed greeter ](https://blog.elementary.io/say-hello-to-the-new-greeter/). Contrary to NixOS\'s usual update policy, Pantheon will receive updates during the cycle of NixOS 20.03 when backwards compatible.

- By default zfs pools will now be trimmed on a weekly basis. Trimming is only done on supported devices (i.e. NVME or SSDs) and should improve throughput and lifetime of these devices. It is controlled by the `services.zfs.trim.enable` varname. The zfs scrub service (`services.zfs.autoScrub.enable`) and the zfs autosnapshot service (`services.zfs.autoSnapshot.enable`) are now only enabled if zfs is set in `config.boot.initrd.supportedFilesystems` or `config.boot.supportedFilesystems`. These lists will automatically contain zfs as soon as any zfs mountpoint is configured in `fileSystems`.

- `nixos-option` has been rewritten in C++, speeding it up, improving correctness, and adding a `-r` option which prints all options and their values recursively.

- `services.xserver.desktopManager.default` and `services.xserver.windowManager.default` options were replaced by a single [services.xserver.displayManager.defaultSession](options.html#opt-services.xserver.displayManager.defaultSession) option to improve support for upstream session files. If you used something like:

  ```nix
  {
    services.xserver.desktopManager.default = "xfce";
    services.xserver.windowManager.default = "icewm";
  }
  ```

  you should change it to:

  ```nix
  {
    services.xserver.displayManager.defaultSession = "xfce+icewm";
  }
  ```

- The testing driver implementation in NixOS is now in Python `make-test-python.nix`. This was done by Jacek Galowicz ([\@tfc](https://github.com/tfc)), and with the collaboration of Julian Stecklina ([\@blitz](https://github.com/blitz)) and Jana Traue ([\@jtraue](https://github.com/jtraue)). All documentation has been updated to use this testing driver, and a vast majority of the 286 tests in NixOS were ported to python driver. In 20.09 the Perl driver implementation, `make-test.nix`, is slated for removal. This should give users of the NixOS integration framework a transitory period to rewrite their tests to use the Python implementation. Users of the Perl driver will see this warning everytime they use it:

  ```ShellSession
  $ warning: Perl VM tests are deprecated and will be removed for 20.09.
  Please update your tests to use the python test driver.
  See https://github.com/NixOS/nixpkgs/pull/71684 for details.
  ```

  API compatibility is planned to be kept for at least the next release with the perl driver.

## New Services {#sec-release-20.03-new-services}

The following new services were added since the last release:

- The kubernetes kube-proxy now supports a new hostname configuration `services.kubernetes.proxy.hostname` which has to be set if the hostname of the node should be non default.

- UPower\'s configuration is now managed by NixOS and can be customized via `services.upower`.

- To use Geary you should enable [programs.geary.enable](options.html#opt-programs.geary.enable) instead of just adding it to [environment.systemPackages](options.html#opt-environment.systemPackages). It was created so Geary could function properly outside of GNOME.

- `./config/console.nix`

- `./hardware/brillo.nix`

- `./hardware/tuxedo-keyboard.nix`

- `./programs/bandwhich.nix`

- `./programs/bash-my-aws.nix`

- `./programs/liboping.nix`

- `./programs/traceroute.nix`

- `./services/backup/sanoid.nix`

- `./services/backup/syncoid.nix`

- `./services/backup/zfs-replication.nix`

- `./services/continuous-integration/buildkite-agents.nix`

- `./services/databases/victoriametrics.nix`

- `./services/desktops/gnome3/gnome-initial-setup.nix`

- `./services/desktops/neard.nix`

- `./services/games/openarena.nix`

- `./services/hardware/fancontrol.nix`

- `./services/mail/sympa.nix`

- `./services/misc/freeswitch.nix`

- `./services/misc/mame.nix`

- `./services/monitoring/do-agent.nix`

- `./services/monitoring/prometheus/xmpp-alerts.nix`

- `./services/network-filesystems/orangefs/server.nix`

- `./services/network-filesystems/orangefs/client.nix`

- `./services/networking/3proxy.nix`

- `./services/networking/corerad.nix`

- `./services/networking/go-shadowsocks2.nix`

- `./services/networking/ntp/openntpd.nix`

- `./services/networking/shorewall.nix`

- `./services/networking/shorewall6.nix`

- `./services/networking/spacecookie.nix`

- `./services/networking/trickster.nix`

- `./services/networking/v2ray.nix`

- `./services/networking/xandikos.nix`

- `./services/networking/yggdrasil.nix`

- `./services/web-apps/dokuwiki.nix`

- `./services/web-apps/gotify-server.nix`

- `./services/web-apps/grocy.nix`

- `./services/web-apps/ihatemoney`

- `./services/web-apps/moinmoin.nix`

- `./services/web-apps/trac.nix`

- `./services/web-apps/trilium.nix`

- `./services/web-apps/shiori.nix`

- `./services/web-servers/ttyd.nix`

- `./services/x11/picom.nix`

- `./services/x11/hardware/digimend.nix`

- `./services/x11/imwheel.nix`

- `./virtualisation/cri-o.nix`

## Backward Incompatibilities {#sec-release-20.03-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- The dhcpcd package [ does not request IPv4 addresses for tap and bridge interfaces anymore by default](https://roy.marples.name/archives/dhcpcd-discuss/0002621.html). In order to still get an address on a bridge interface, one has to disable `networking.useDHCP` and explicitly enable `networking.interfaces.<name>.useDHCP` on every interface, that should get an address via DHCP. This way, dhcpcd is configured in an explicit way about which interface to run on.

- GnuPG is now built without support for a graphical passphrase entry by default. Please enable the `gpg-agent` user service via the NixOS option `programs.gnupg.agent.enable`. Note that upstream recommends using `gpg-agent` and will spawn a `gpg-agent` on the first invocation of GnuPG anyway.

- The `dynamicHosts` option has been removed from the [NetworkManager](options.html#opt-networking.networkmanager.enable) module. Allowing (multiple) regular users to override host entries affecting the whole system opens up a huge attack vector. There seem to be very rare cases where this might be useful. Consider setting system-wide host entries using [networking.hosts](options.html#opt-networking.hosts), provide them via the DNS server in your network, or use [environment.etc](options.html#opt-environment.etc) to add a file into `/etc/NetworkManager/dnsmasq.d` reconfiguring `hostsdir`.

- The `99-main.network` file was removed. Matching all network interfaces caused many breakages, see [\#18962](https://github.com/NixOS/nixpkgs/pull/18962) and [\#71106](https://github.com/NixOS/nixpkgs/pull/71106).

  We already don\'t support the global [networking.useDHCP](options.html#opt-networking.useDHCP), [networking.defaultGateway](options.html#opt-networking.defaultGateway) and [networking.defaultGateway6](options.html#opt-networking.defaultGateway6) options if [networking.useNetworkd](options.html#opt-networking.useNetworkd) is enabled, but direct users to configure the per-device [networking.interfaces.\<name\>....](options.html#opt-networking.interfaces) options.

- The stdenv now runs all bash with `set -u`, to catch the use of undefined variables. Before, it itself used `set -u` but was careful to unset it so other packages\' code ran as before. Now, all bash code is held to the same high standard, and the rather complex stateful manipulation of the options can be discarded.

- The SLIM Display Manager has been removed, as it has been unmaintained since 2013. Consider migrating to a different display manager such as LightDM (current default in NixOS), SDDM, GDM, or using the startx module which uses Xinitrc.

- The Way Cooler wayland compositor has been removed, as the project has been officially canceled. There are no more `way-cooler` attribute and `programs.way-cooler` options.

- The BEAM package set has been deleted. You will only find there the different interpreters. You should now use the different build tools coming with the languages with sandbox mode disabled.

- There is now only one Xfce package-set and module. This means that attributes `xfce4-14` and `xfceUnstable` all now point to the latest Xfce 4.14 packages. And in the future NixOS releases will be the latest released version of Xfce available at the time of the release\'s development (if viable).

- The [phpfpm](options.html#opt-services.phpfpm.pools) module now sets `PrivateTmp=true` in its systemd units for better process isolation. If you rely on `/tmp` being shared with other services, explicitly override this by setting `serviceConfig.PrivateTmp` to `false` for each phpfpm unit.

- KDE's old multimedia framework Phonon no longer supports Qt 4. For that reason, Plasma desktop also does not have `enableQt4Support` option any more.

- The BeeGFS module has been removed.

- The osquery module has been removed.

- Going forward, `~/bin` in the users home directory will no longer be in `PATH` by default. If you depend on this you should set the option `environment.homeBinInPath` to `true`. The aforementioned option was added this release.

- The `buildRustCrate` infrastructure now produces `lib` outputs in addition to the `out` output. This has led to drastically reduced closure sizes for some rust crates since development dependencies are now in the `lib` output.

- Pango was upgraded to 1.44, which no longer uses freetype for font loading. This means that type1 and bitmap fonts are no longer supported in applications relying on Pango for font rendering (notably, GTK application). See [ upstream issue](https://gitlab.gnome.org/GNOME/pango/issues/386) for more information.

- The `roundcube` module has been hardened.

  - The password of the database is not written world readable in the store any more. If `database.host` is set to `localhost`, then a unix user of the same name as the database will be created and PostreSQL peer authentication will be used, removing the need for a password. Otherwise, a password is still needed and can be provided with the new option `database.passwordFile`, which should be set to the path of a file containing the password and readable by the user `nginx` only. The `database.password` option is insecure and deprecated. Usage of this option will print a warning.

  - A random `des_key` is set by default in the configuration of roundcube, instead of using the hardcoded and insecure default. To ensure a clean migration, all users will be logged out when you upgrade to this release.

- The packages `openobex` and `obexftp` are no longer installed when enabling Bluetooth via `hardware.bluetooth.enable`.

- The `dump1090` derivation has been changed to use FlightAware\'s dump1090 as its upstream. However, this version does not have an internal webserver anymore. The assets in the `share/dump1090` directory of the derivation can be used in conjunction with an external webserver to replace this functionality.

- The fourStore and fourStoreEndpoint modules have been removed.

- Polkit no longer has the user of uid 0 (root) as an admin identity. We now follow the upstream default of only having every member of the wheel group admin privileged. Before it was root and members of wheel. The positive outcome of this is pkexec GUI popups or terminal prompts will no longer require the user to choose between two essentially equivalent choices (whether to perform the action as themselves with wheel permissions, or as the root user).

- NixOS containers no longer build NixOS manual by default. This saves evaluation time, especially if there are many declarative containers defined. Note that this is already done when `<nixos/modules/profiles/minimal.nix>` module is included in container config.

- The `kresd` services deprecates the `interfaces` option in favor of the `listenPlain` option which requires full [systemd.socket compatible](https://www.freedesktop.org/software/systemd/man/systemd.socket.html#ListenStream=) declaration which always include a port.

- Virtual console options have been reorganized and can be found under a single top-level attribute: `console`. The full set of changes is as follows:

  - `i18n.consoleFont` renamed to [console.font](options.html#opt-console.font)

  - `i18n.consoleKeyMap` renamed to [console.keyMap](options.html#opt-console.keyMap)

  - `i18n.consoleColors` renamed to [console.colors](options.html#opt-console.colors)

  - `i18n.consolePackages` renamed to [console.packages](options.html#opt-console.packages)

  - `i18n.consoleUseXkbConfig` renamed to [console.useXkbConfig](options.html#opt-console.useXkbConfig)

  - `boot.earlyVconsoleSetup` renamed to [console.earlySetup](options.html#opt-console.earlySetup)

  - `boot.extraTTYs` renamed to `console.extraTTYs`.

- The [awstats](options.html#opt-services.awstats.enable) module has been rewritten to serve stats via static html pages, updated on a timer, over [nginx](options.html#opt-services.nginx.virtualHosts), instead of dynamic cgi pages over [apache](options.html#opt-services.httpd.enable).

  Minor changes will be required to migrate existing configurations. Details of the required changes can seen by looking through the [awstats](options.html#opt-services.awstats.enable) module.

- The httpd module no longer provides options to support serving web content without defining a virtual host. As a result of this the [services.httpd.logPerVirtualHost](options.html#opt-services.httpd.logPerVirtualHost) option now defaults to `true` instead of `false`. Please update your configuration to make use of [services.httpd.virtualHosts](options.html#opt-services.httpd.virtualHosts).

  The [services.httpd.virtualHosts.\<name\>](options.html#opt-services.httpd.virtualHosts) option has changed type from a list of submodules to an attribute set of submodules, better matching [services.nginx.virtualHosts.\<name\>](options.html#opt-services.nginx.virtualHosts).

  This change comes with the addition of the following options which mimic the functionality of their `nginx` counterparts: [services.httpd.virtualHosts.\<name\>.addSSL](options.html#opt-services.httpd.virtualHosts), [services.httpd.virtualHosts.\<name\>.forceSSL](options.html#opt-services.httpd.virtualHosts), [services.httpd.virtualHosts.\<name\>.onlySSL](options.html#opt-services.httpd.virtualHosts), [services.httpd.virtualHosts.\<name\>.enableACME](options.html#opt-services.httpd.virtualHosts), [services.httpd.virtualHosts.\<name\>.acmeRoot](options.html#opt-services.httpd.virtualHosts), and [services.httpd.virtualHosts.\<name\>.useACMEHost](options.html#opt-services.httpd.virtualHosts).

- For NixOS configuration options, the `loaOf` type has been deprecated and will be removed in a future release. In nixpkgs, options of this type will be changed to `attrsOf` instead. If you were using one of these in your configuration, you will see a warning suggesting what changes will be required.

  For example, [users.users](options.html#opt-users.users) is a `loaOf` option that is commonly used as follows:

  ```nix
  {
    users.users =
      [ { name = "me";
          description = "My personal user.";
          isNormalUser = true;
        }
      ];
  }
  ```

  This should be rewritten by removing the list and using the value of `name` as the name of the attribute set:

  ```nix
  {
    users.users.me =
      { description = "My personal user.";
        isNormalUser = true;
      };
  }
  ```

  For more information on this change have look at these links: [issue \#1800](https://github.com/NixOS/nixpkgs/issues/1800), [PR \#63103](https://github.com/NixOS/nixpkgs/pull/63103).

- For NixOS modules, the types `types.submodule` and `types.submoduleWith` now support paths as allowed values, similar to how `imports` supports paths. Because of this, if you have a module that defines an option of type `either (submodule ...) path`, it will break since a path is now treated as the first type instead of the second. To fix this, change the type to `either path (submodule ...)`.

- The [Buildkite Agent](options.html#opt-services.buildkite-agents) module and corresponding packages have been updated to 3.x, and to support multiple instances of the agent running at the same time. This means you will have to rename `services.buildkite-agent` to `services.buildkite-agents.<name>`. Furthermore, the following options have been changed:

  - `services.buildkite-agent.meta-data` has been renamed to [services.buildkite-agents.\<name\>.tags](options.html#opt-services.buildkite-agents), to match upstreams naming for 3.x. Its type has also changed - it now accepts an attrset of strings.

  - The`services.buildkite-agent.openssh.publicKeyPath` option has been removed, as it\'s not necessary to deploy public keys to clone private repositories.

  - `services.buildkite-agent.openssh.privateKeyPath` has been renamed to [buildkite-agents.\<name\>.privateSshKeyPath](options.html#opt-services.buildkite-agents), as the whole `openssh` now only contained that single option.

  - [services.buildkite-agents.\<name\>.shell](options.html#opt-services.buildkite-agents) has been introduced, allowing to specify a custom shell to be used.

- The `citrix_workspace_19_3_0` package has been removed as it will be EOLed within the lifespan of 20.03. For further information, please refer to the [support and maintenance information](https://www.citrix.com/de-de/support/product-lifecycle/milestones/receiver.html) from upstream.

- The `gcc5` and `gfortran5` packages have been removed.

- The `services.xserver.displayManager.auto` module has been removed. It was only intended for use in internal NixOS tests, and gave the false impression of it being a special display manager when it\'s actually LightDM. Please use the `services.xserver.displayManager.lightdm.autoLogin` options instead, or any other display manager in NixOS as they all support auto-login. If you used this module specifically because it permitted root auto-login you can override the lightdm-autologin pam module like:

  ```nix
  {
    security.pam.services.lightdm-autologin.text = lib.mkForce ''
        auth     requisite pam_nologin.so
        auth     required  pam_succeed_if.so quiet
        auth     required  pam_permit.so

        account  include   lightdm

        password include   lightdm

        session  include   lightdm
    '';
  }
  ```

  The difference is the:

  ```
  auth required pam_succeed_if.so quiet
  ```

  line, where default it\'s:

  ```
   auth required pam_succeed_if.so uid >= 1000 quiet
  ```

  not permitting users with uid\'s below 1000 (like root). All other display managers in NixOS are configured like this.

- There have been lots of improvements to the Mailman module. As a result,

  - The `services.mailman.hyperkittyBaseUrl` option has been renamed to [services.mailman.hyperkitty.baseUrl](options.html#opt-services.mailman.hyperkitty.baseUrl).

  - The `services.mailman.hyperkittyApiKey` option has been removed. This is because having an option for the Hyperkitty API key meant that the API key would be stored in the world-readable Nix store, which was a security vulnerability. A new Hyperkitty API key will be generated the first time the new Hyperkitty service is run, and it will then be persisted outside of the Nix store. To continue using Hyperkitty, you must set [services.mailman.hyperkitty.enable](options.html#opt-services.mailman.hyperkitty.enable) to `true`.

  - Additionally, some Postfix configuration must now be set manually instead of automatically by the Mailman module:

    ```nix
    {
      services.postfix.relayDomains = [ "hash:/var/lib/mailman/data/postfix_domains" ];
      services.postfix.config.transport_maps = [ "hash:/var/lib/mailman/data/postfix_lmtp" ];
      services.postfix.config.local_recipient_maps = [ "hash:/var/lib/mailman/data/postfix_lmtp" ];
    }
    ```

    This is because some users may want to include other values in these lists as well, and this was not possible if they were set automatically by the Mailman module. It would not have been possible to just concatenate values from multiple modules each setting the values they needed, because the order of elements in the list is significant.

- The LLVM versions 3.5, 3.9 and 4 (including the corresponding CLang versions) have been dropped.

- The `networking.interfaces.*.preferTempAddress` option has been replaced by `networking.interfaces.*.tempAddress`. The new option allows better control of the IPv6 temporary addresses, including completely disabling them for interfaces where they are not needed.

- Rspamd was updated to version 2.2. Read [ the upstream migration notes](https://rspamd.com/doc/migration.html#migration-to-rspamd-20) carefully. Please be especially aware that some modules were removed and the default Bayes backend is now Redis.

- The `*psu` versions of oraclejdk8 have been removed as they aren\'t provided by upstream anymore.

- The `services.dnscrypt-proxy` module has been removed as it used the deprecated version of dnscrypt-proxy. We\'ve added [services.dnscrypt-proxy2.enable](options.html#opt-services.dnscrypt-proxy2.enable) to use the supported version. This module supports configuration via the Nix attribute set [services.dnscrypt-proxy2.settings](options.html#opt-services.dnscrypt-proxy2.settings), or by passing a TOML configuration file via [services.dnscrypt-proxy2.configFile](options.html#opt-services.dnscrypt-proxy2.configFile).

  ```nix
  {
    # Example configuration:
    services.dnscrypt-proxy2.enable = true;
    services.dnscrypt-proxy2.settings = {
      listen_addresses = [ "127.0.0.1:43" ];
      sources.public-resolvers = {
        urls = [ "https://download.dnscrypt.info/resolvers-list/v2/public-resolvers.md" ];
        cache_file = "public-resolvers.md";
        minisign_key = "RWQf6LRCGA9i53mlYecO4IzT51TGPpvWucNSCh1CBM0QTaLn73Y7GFO3";
        refresh_delay = 72;
      };
    };

    services.dnsmasq.enable = true;
    services.dnsmasq.servers = [ "127.0.0.1#43" ];
  }
  ```

- `qesteidutil` has been deprecated in favor of `qdigidoc`.

- sqldeveloper_18 has been removed as it\'s not maintained anymore, sqldeveloper has been updated to version `19.4`. Please note that this means that this means that the oraclejdk is now required. For further information please read the [release notes](https://www.oracle.com/technetwork/developer-tools/sql-developer/downloads/sqldev-relnotes-194-5908846.html).

- Haskell `env` and `shellFor` dev shell environments now organize dependencies the same way as regular builds. In particular, rather than receiving all the different lists of dependencies mashed together as one big list, and then partitioning into Haskell and non-Hakell dependencies, they work from the original many different dependency parameters and don\'t need to algorithmically partition anything.

  This means that if you incorrectly categorize a dependency, e.g. non-Haskell library dependency as a `buildDepends` or run-time Haskell dependency as a `setupDepends`, whereas things would have worked before they may not work now.

- The gcc-snapshot-package has been removed. It\'s marked as broken for \>2 years and used to point to a fairly old snapshot from the gcc7-branch.

- The nixos-build-vms8 -script now uses the python test-driver.

- The riot-web package now accepts configuration overrides as an attribute set instead of a string. A formerly used JSON configuration can be converted to an attribute set with `builtins.fromJSON`.

  The new default configuration also disables automatic guest account registration and analytics to improve privacy. The previous behavior can be restored by setting `config.riot-web.conf = { disable_guests = false; piwik = true; }`.

- Stand-alone usage of `Upower` now requires `services.upower.enable` instead of just installing into [environment.systemPackages](options.html#opt-environment.systemPackages).

- nextcloud has been updated to `v18.0.2`. This means that users from NixOS 19.09 can\'t upgrade directly since you can only move one version forward and 19.09 uses `v16.0.8`.

  To provide a safe upgrade-path and to circumvent similar issues in the future, the following measures were taken:

  - The pkgs.nextcloud-attribute has been removed and replaced with versioned attributes (currently pkgs.nextcloud17 and pkgs.nextcloud18). With this change major-releases can be backported without breaking stuff and to make upgrade-paths easier.

  - Existing setups will be detected using [system.stateVersion](options.html#opt-system.stateVersion): by default, nextcloud17 will be used, but will raise a warning which notes that after that deploy it\'s recommended to update to the latest stable version (nextcloud18) by declaring the newly introduced setting [services.nextcloud.package](options.html#opt-services.nextcloud.package).

  - Users with an overlay (e.g. to use nextcloud at version `v18` on `19.09`) will get an evaluation error by default. This is done to ensure that our [package](options.html#opt-services.nextcloud.package)-option doesn\'t select an older version by accident. It\'s recommended to use pkgs.nextcloud18 or to set [package](options.html#opt-services.nextcloud.package) to pkgs.nextcloud explicitly.

  ::: {.warning}
  Please note that if you\'re coming from `19.03` or older, you have to manually upgrade to `19.09` first to upgrade your server to Nextcloud v16.
  :::

- Hydra has gained a massive performance improvement due to [some database schema changes](https://github.com/NixOS/hydra/pull/710) by adding several IDs and better indexing. However, it\'s necessary to upgrade Hydra in multiple steps:

  - At first, an older version of Hydra needs to be deployed which adds those (nullable) columns. When having set [stateVersion ](options.html#opt-system.stateVersion) to a value older than `20.03`, this package will be selected by default from the module when upgrading. Otherwise, the package can be deployed using the following config:

    ```nix
    { pkgs, ... }: {
      services.hydra.package = pkgs.hydra-migration;
    }
    ```

- Automatically fill the newly added ID columns on the server by running the following command:

  ```ShellSession
  $ hydra-backfill-ids
  ```
  ::: {.warning}
  Please note that this process can take a while depending on your database-size!
  :::

- Deploy a newer version of Hydra to activate the DB optimizations. This can be done by using hydra-unstable. This package already includes [flake-support](https://github.com/nixos/rfcs/pull/49) and is therefore compiled against pkgs.nixFlakes.

  ::: {.warning}
  If your [stateVersion](options.html#opt-system.stateVersion) is set to `20.03` or greater, hydra-unstable will be used automatically! This will break your setup if you didn\'t run the migration.
  :::

  Please note that Hydra is currently not available with nixStable as this doesn\'t compile anymore.

  ::: {.warning}
  pkgs.hydra has been removed to ensure a graceful database-migration using the dedicated package-attributes. If you still have pkgs.hydra defined in e.g. an overlay, an assertion error will be thrown. To circumvent this, you need to set [services.hydra.package](options.html#opt-services.hydra.package) to pkgs.hydra explicitly and make sure you know what you\'re doing!
  :::

- The TokuDB storage engine will be disabled in mariadb 10.5. It is recommended to switch to RocksDB. See also [TokuDB](https://mariadb.com/kb/en/tokudb/).

## Other Notable Changes {#sec-release-20.03-notable-changes}

- SD images are now compressed by default using `bzip2`.

- The nginx web server previously started its master process as root privileged, then ran worker processes as a less privileged identity user (the `nginx` user). This was changed to start all of nginx as a less privileged user (defined by `services.nginx.user` and `services.nginx.group`). As a consequence, all files that are needed for nginx to run (included configuration fragments, SSL certificates and keys, etc.) must now be readable by this less privileged user/group.

  To continue to use the old approach, you can configure:

  ```nix
  {
    services.nginx.appendConfig = let cfg = config.services.nginx; in ''user ${cfg.user} ${cfg.group};'';
    systemd.services.nginx.serviceConfig.User = lib.mkForce "root";
  }
  ```

- OpenSSH has been upgraded from 7.9 to 8.1, improving security and adding features but with potential incompatibilities. Consult the [ release announcement](https://www.openssh.com/txt/release-8.1) for more information.

- `PRETTY_NAME` in `/etc/os-release` now uses the short rather than full version string.

- The ACME module has switched from simp-le to [lego](https://github.com/go-acme/lego) which allows us to support DNS-01 challenges and wildcard certificates. The following options have been added: [security.acme.acceptTerms](options.html#opt-security.acme.acceptTerms), [security.acme.certs.\<name\>.dnsProvider](options.html#opt-security.acme.certs), [security.acme.certs.\<name\>.credentialsFile](options.html#opt-security.acme.certs), [security.acme.certs.\<name\>.dnsPropagationCheck](options.html#opt-security.acme.certs). As well as this, the options `security.acme.acceptTerms` and either `security.acme.email` or `security.acme.certs.<name>.email` must be set in order to use the ACME module. Certificates will be regenerated on activation, no account or certificate will be migrated from simp-le. In particular private keys will not be preserved. However, the credentials for simp-le are preserved and thus it is possible to roll back to previous versions without breaking certificate generation. Note also that in contrary to simp-le a new private key is recreated at each renewal by default, which can have consequences if you embed your public key in apps.

- It is now possible to unlock LUKS-Encrypted file systems using a FIDO2 token via `boot.initrd.luks.fido2Support`.

- Predictably named network interfaces get renamed in stage-1. This means that it is possible to use the proper interface name for e.g. Dropbear setups.

  For further reference, please read [\#68953](https://github.com/NixOS/nixpkgs/pull/68953) or the corresponding [discourse thread](https://discourse.nixos.org/t/predictable-network-interface-names-in-initrd/4055).

- The matrix-synapse-package has been updated to [v1.11.1](https://github.com/matrix-org/synapse/releases/tag/v1.11.1). Due to [stricter requirements](https://github.com/matrix-org/synapse/releases/tag/v1.10.0rc1) for database configuration when using postgresql, the automated database setup of the module has been removed to avoid any further edge-cases.

  matrix-synapse expects `postgresql`-databases to have the options `LC_COLLATE` and `LC_CTYPE` set to [`'C'`](https://www.postgresql.org/docs/12/locale.html) which basically instructs `postgresql` to ignore any locale-based preferences.

  Depending on your setup, you need to incorporate one of the following changes in your setup to upgrade to 20.03:

  - If you use `sqlite3` you don\'t need to do anything.

  - If you use `postgresql` on a different server, you don\'t need to change anything as well since this module was never designed to configure remote databases.

  - If you use `postgresql` and configured your synapse initially on `19.09` or older, you simply need to enable postgresql-support explicitly:

    ```nix
    { ... }: {
      services.matrix-synapse = {
        enable = true;
        /* and all the other config you've defined here */
      };
      services.postgresql.enable = true;
    }
    ```

- If you deploy a fresh matrix-synapse, you need to configure the database yourself (e.g. by using the [services.postgresql.initialScript](options.html#opt-services.postgresql.initialScript) option). An example for this can be found in the [documentation of the Matrix module](#module-services-matrix).

- If you initially deployed your matrix-synapse on `nixos-unstable` _after_ the `19.09`-release, your database is misconfigured due to a regression in NixOS. For now, matrix-synapse will startup with a warning, but it\'s recommended to reconfigure the database to set the values `LC_COLLATE` and `LC_CTYPE` to [`'C'`](https://www.postgresql.org/docs/12/locale.html).

- The [systemd.network.links](options.html#opt-systemd.network.links) option is now respected even when [systemd-networkd](options.html#opt-systemd.network.enable) is disabled. This mirrors the behaviour of systemd - It\'s udev that parses `.link` files, not `systemd-networkd`.

- mongodb has been updated to version `3.4.24`.

  ::: {.warning}
  Please note that mongodb has been relicensed under their own [` sspl`](https://www.mongodb.com/licensing/server-side-public-license/faq)-license. Since it\'s not entirely free and not OSI-approved, it\'s listed as non-free. This means that Hydra doesn\'t provide prebuilt mongodb-packages and needs to be built locally.
  :::
