# Release 21.05 ("Okapi", 2021.05/31) {#sec-release-21.05}

Support is planned until the end of December 2021, handing over to 21.11.

## Highlights {#sec-release-21.05-highlights}

In addition to numerous new and upgraded packages, this release has the following highlights:

- Core version changes:

  - gcc: 9.3.0 -\> 10.3.0

  - glibc: 2.30 -\> 2.32

  - default linux: 5.4 -\> 5.10, all supported kernels available

  - mesa: 20.1.7 -\> 21.0.1

- Desktop Environments:

  - GNOME: 3.36 -\> 40, see its [release notes](https://help.gnome.org/misc/release-notes/40.0/)

  - Plasma5: 5.18.5 -\> 5.21.3

  - kdeApplications: 20.08.1 -\> 20.12.3

  - cinnamon: 4.6 -\> 4.8.1

- Programming Languages and Frameworks:

  - Python optimizations were disabled again. Builds with optimizations enabled are not reproducible. Optimizations can now be enabled with an option.

- The linux_latest kernel was updated to the 5.13 series. It currently is not officially supported for use with the zfs filesystem. If you use zfs, you should use a different kernel version (either the LTS kernel, or track a specific one).

## New Services {#sec-release-21.05-new-services}

The following new services were added since the last release:

- [GNURadio](https://www.gnuradio.org/) 3.8 and 3.9 were [finally](https://github.com/NixOS/nixpkgs/issues/82263) packaged, along with a rewrite to the Nix expressions, allowing users to override the features upstream supports selecting to compile or not to. Additionally, the attribute `gnuradio` (3.9), `gnuradio3_8` and `gnuradio3_7` now point to an externally wrapped by default derivations, that allow you to also add \`extraPythonPackages\` to the Python interpreter used by GNURadio. Missing environmental variables needed for operational GUI were also added ([\#75478](https://github.com/NixOS/nixpkgs/issues/75478)).

- [Keycloak](https://www.keycloak.org/), an open source identity and access management server with support for [OpenID Connect](https://openid.net/connect/), [OAUTH 2.0](https://oauth.net/2/) and [SAML 2.0](https://en.wikipedia.org/wiki/SAML_2.0).

  See the [Keycloak section of the NixOS manual](#module-services-keycloak) for more information.

- [services.samba-wsdd.enable](options.html#opt-services.samba-wsdd.enable) Web Services Dynamic Discovery host daemon

- [Discourse](https://www.discourse.org/), a modern and open source discussion platform.

  See the [Discourse section of the NixOS manual](#module-services-discourse) for more information.

- [services.nebula.networks](options.html#opt-services.nebula.networks) [Nebula VPN](https://github.com/slackhq/nebula)

## Backward Incompatibilities {#sec-release-21.05-incompatibilities}

When upgrading from a previous release, please be aware of the following incompatible changes:

- GNOME desktop environment was upgraded to 40, see the release notes for [40.0](https://help.gnome.org/misc/release-notes/40.0/) and [3.38](https://help.gnome.org/misc/release-notes/3.38/). The `gnome3` attribute set has been renamed to `gnome` and so have been the NixOS options.

- If you are using `services.udev.extraRules` to assign custom names to network interfaces, this may stop working due to a change in the initialisation of dhcpcd and systemd networkd. To avoid this, either move them to `services.udev.initrdRules` or see the new [Assigning custom names](#sec-custom-ifnames) section of the NixOS manual for an example using networkd links.

- The `security.hideProcessInformation` module has been removed. It was broken since the switch to cgroups-v2.

- The `linuxPackages.ati_drivers_x11` kernel modules have been removed. The drivers only supported kernels prior to 4.2, and thus have become obsolete.

- The `systemConfig` kernel parameter is no longer added to boot loader entries. It has been unused since September 2010, but if do have a system generation from that era, you will now be unable to boot into them.

- `systemd-journal2gelf` no longer parses json and expects the receiving system to handle it. How to achieve this with Graylog is described in this [GitHub issue](https://github.com/parse-nl/SystemdJournal2Gelf/issues/10).

- If the `services.dbus` module is enabled, then the user D-Bus session is now always socket activated. The associated options `services.dbus.socketActivated` and `services.xserver.startDbusSession` have therefore been removed and you will receive a warning if they are present in your configuration. This change makes the user D-Bus session available also for non-graphical logins.

- The `networking.wireless.iwd` module now installs the upstream-provided 80-iwd.link file, which sets the NamePolicy= for all wlan devices to \"keep kernel\", to avoid race conditions between iwd and networkd. If you don\'t want this, you can set `systemd.network.links."80-iwd" = lib.mkForce {}`.

- `rubyMinimal` was removed due to being unused and unusable. The default ruby interpreter includes JIT support, which makes it reference it\'s compiler. Since JIT support is probably needed by some Gems, it was decided to enable this feature with all cc references by default, and allow to build a Ruby derivation without references to cc, by setting `jitSupport = false;` in an overlay. See [\#90151](https://github.com/NixOS/nixpkgs/pull/90151) for more info.

- Setting `services.openssh.authorizedKeysFiles` now also affects which keys `security.pam.enableSSHAgentAuth` will use. WARNING: If you are using these options in combination do make sure that any key paths you use are present in `services.openssh.authorizedKeysFiles`!

- The option `fonts.enableFontDir` has been renamed to [fonts.fontDir.enable](options.html#opt-fonts.fontDir.enable). The path of font directory has also been changed to `/run/current-system/sw/share/X11/fonts`, for consistency with other X11 resources.

- A number of options have been renamed in the kicad interface. `oceSupport` has been renamed to `withOCE`, `withOCCT` has been renamed to `withOCC`, `ngspiceSupport` has been renamed to `withNgspice`, and `scriptingSupport` has been renamed to `withScripting`. Additionally, `kicad/base.nix` no longer provides default argument values since these are provided by `kicad/default.nix`.

- The socket for the `pdns-recursor` module was moved from `/var/lib/pdns-recursor` to `/run/pdns-recursor` to match upstream.

- Paperwork was updated to version 2. The on-disk format slightly changed, and it is not possible to downgrade from Paperwork 2 back to Paperwork 1.3. Back your documents up before upgrading. See [this thread](https://forum.openpaper.work/t/paperwork-2-0/112/5) for more details.

- PowerDNS has been updated from `4.2.x` to `4.3.x`. Please be sure to review the [Upgrade Notes](https://doc.powerdns.com/authoritative/upgrading.html#x-to-4-3-0) provided by upstream before upgrading. Worth specifically noting is that the service now runs entirely as a dedicated `pdns` user, instead of starting as `root` and dropping privileges, as well as the default `socket-dir` location changing from `/var/lib/powerdns` to `/run/pdns`.

- The `mediatomb` service is now using by default the new and maintained fork `gerbera` package instead of the unmaintained `mediatomb` package. If you want to keep the old behavior, you must declare it with:

  ```nix
  {
    services.mediatomb.package = pkgs.mediatomb;
  }
  ```

  One new option `openFirewall` has been introduced which defaults to false. If you relied on the service declaration to add the firewall rules itself before, you should now declare it with:

  ```nix
  {
    services.mediatomb.openFirewall = true;
  }
  ```

- xfsprogs was update from 4.19 to 5.11. It now enables reflink support by default on filesystem creation. Support for reflinks was added with an experimental status to kernel 4.9 and deemed stable in kernel 4.16. If you want to be able to mount XFS filesystems created with this release of xfsprogs on kernel releases older than those, you need to format them with `mkfs.xfs -m reflink=0`.

- The uWSGI server is now built with POSIX capabilities. As a consequence, root is no longer required in emperor mode and the service defaults to running as the unprivileged `uwsgi` user. Any additional capability can be added via the new option [services.uwsgi.capabilities](options.html#opt-services.uwsgi.capabilities). The previous behaviour can be restored by setting:

  ```nix
  {
    services.uwsgi.user = "root";
    services.uwsgi.group = "root";
    services.uwsgi.instance =
      {
        uid = "uwsgi";
        gid = "uwsgi";
      };
  }
  ```

  Another incompatibility from the previous release is that vassals running under a different user or group need to use `immediate-{uid,gid}` instead of the usual `uid,gid` options.

- btc1 has been abandoned upstream, and removed.

- cpp_ethereum (aleth) has been abandoned upstream, and removed.

- riak-cs package removed along with `services.riak-cs` module.

- stanchion package removed along with `services.stanchion` module.

- mutt has been updated to a new major version (2.x), which comes with some backward incompatible changes that are described in the [release notes for Mutt 2.0](http://www.mutt.org/relnotes/2.0/).

- `vim` and `neovim` switched to Python 3, dropping all Python 2 support.

- [networking.wireguard.interfaces.\<name\>.generatePrivateKeyFile](options.html#opt-networking.wireguard.interfaces), which is off by default, had a `chmod` race condition fixed. As an aside, the parent directory\'s permissions were widened, and the key files were made owner-writable. This only affects newly created keys. However, if the exact permissions are important for your setup, read [\#121294](https://github.com/NixOS/nixpkgs/pull/121294).

- [boot.zfs.forceImportAll](options.html#opt-boot.zfs.forceImportAll) previously did nothing, but has been fixed. However its default has been changed to `false` to preserve the existing default behaviour. If you have this explicitly set to `true`, please note that your non-root pools will now be forcibly imported.

- openafs now points to openafs_1_8, which is the new stable release. OpenAFS 1.6 was removed.

- The WireGuard module gained a new option `networking.wireguard.interfaces.<name>.peers.*.dynamicEndpointRefreshSeconds` that implements refreshing the IP of DNS-based endpoints periodically (which WireGuard itself [cannot do](https://lists.zx2c4.com/pipermail/wireguard/2017-November/002028.html)).

- MariaDB has been updated to 10.5. Before you upgrade, it would be best to take a backup of your database and read [ Incompatible Changes Between 10.4 and 10.5](https://mariadb.com/kb/en/upgrading-from-mariadb-104-to-mariadb-105/#incompatible-changes-between-104-and-105). After the upgrade you will need to run `mysql_upgrade`.

- The TokuDB storage engine dropped in mariadb 10.5 and removed in mariadb 10.6. It is recommended to switch to RocksDB. See also [TokuDB](https://mariadb.com/kb/en/tokudb/) and [MDEV-19780: Remove the TokuDB storage engine](https://jira.mariadb.org/browse/MDEV-19780).

- The `openldap` module now has support for OLC-style configuration, users of the `configDir` option may wish to migrate. If you continue to use `configDir`, ensure that `olcPidFile` is set to `/run/slapd/slapd.pid`.

  As a result, `extraConfig` and `extraDatabaseConfig` are removed. To help with migration, you can convert your `slapd.conf` file to OLC configuration with the following script (find the location of this configuration file by running `systemctl status openldap`, it is the `-f` option.

  ```ShellSession
  $ TMPDIR=$(mktemp -d)
  $ slaptest -f /path/to/slapd.conf -F $TMPDIR
  $ slapcat -F $TMPDIR -n0 -H 'ldap:///???(!(objectClass=olcSchemaConfig))'
  ```

  This will dump your current configuration in LDIF format, which should be straightforward to convert into Nix settings. This does not show your schema configuration, as this is unnecessarily verbose for users of the default schemas and `slaptest` is buggy with schemas directly in the config file.

- Amazon EC2 and OpenStack Compute (nova) images now re-fetch instance meta data and user data from the instance metadata service (IMDS) on each boot. For example: stopping an EC2 instance, changing its user data, and restarting the instance will now cause it to fetch and apply the new user data.

  ::: {.warning}
  Specifically, `/etc/ec2-metadata` is re-populated on each boot. Some NixOS scripts that read from this directory are guarded to only run if the files they want to manipulate do not already exist, and so will not re-apply their changes if the IMDS response changes. Examples: `root`\'s SSH key is only added if `/root/.ssh/authorized_keys` does not exist, and SSH host keys are only set from user data if they do not exist in `/etc/ssh`.
  :::

- The `rspamd` services is now sandboxed. It is run as a dynamic user instead of root, so secrets and other files may have to be moved or their permissions may have to be fixed. The sockets are now located in `/run/rspamd` instead of `/run`.

- Enabling the Tor client no longer silently also enables and configures Privoxy, and the `services.tor.client.privoxy.enable` option has been removed. To enable Privoxy, and to configure it to use Tor\'s faster port, use the following configuration:

  ```nix
  {
    opt-services.privoxy.enable = true;
    opt-services.privoxy.enableTor = true;
  }
  ```

- The `services.tor` module has a new exhaustively typed [services.tor.settings](options.html#opt-services.tor.settings) option following RFC 0042; backward compatibility with old options has been preserved when aliasing was possible. The corresponding systemd service has been hardened, but there is a chance that the service still requires more permissions, so please report any related trouble on the bugtracker. Onion services v3 are now supported in [services.tor.relay.onionServices](options.html#opt-services.tor.relay.onionServices). A new [services.tor.openFirewall](options.html#opt-services.tor.openFirewall) option as been introduced for allowing connections on all the TCP ports configured.

- The options `services.slurm.dbdserver.storagePass` and `services.slurm.dbdserver.configFile` have been removed. Use `services.slurm.dbdserver.storagePassFile` instead to provide the database password. Extra config options can be given via the option `services.slurm.dbdserver.extraConfig`. The actual configuration file is created on the fly on startup of the service. This avoids that the password gets exposed in the nix store.

- The `wafHook` hook does not wrap Python anymore. Packages depending on `wafHook` need to include any Python into their `nativeBuildInputs`.

- Starting with version 1.7.0, the project formerly named `CodiMD` is now named `HedgeDoc`. New installations will no longer use the old name for users, state directories and such, this needs to be considered when moving state to a more recent NixOS installation. Based on [system.stateVersion](options.html#opt-system.stateVersion), existing installations will continue to work.

- The fish-foreign-env package has been replaced with fishPlugins.foreign-env, in which the fish functions have been relocated to the `vendor_functions.d` directory to be loaded automatically.

- The prometheus json exporter is now managed by the prometheus community. Together with additional features some backwards incompatibilities were introduced. Most importantly the exporter no longer accepts a fixed command-line parameter to specify the URL of the endpoint serving JSON. It now expects this URL to be passed as an URL parameter, when scraping the exporter\'s `/probe` endpoint. In the prometheus scrape configuration the scrape target might look like this:

  ```
  http://some.json-exporter.host:7979/probe?target=https://example.com/some/json/endpoint
  ```

  Existing configuration for the exporter needs to be updated, but can partially be re-used. Documentation is available in the upstream repository and a small example for NixOS is available in the corresponding NixOS test.

  These changes also affect [services.prometheus.exporters.rspamd.enable](options.html#opt-services.prometheus.exporters.rspamd.enable), which is just a preconfigured instance of the json exporter.

  For more information, take a look at the [ official documentation](https://github.com/prometheus-community/json_exporter) of the json_exporter.

- Androidenv was updated, removing the `includeDocs` and `lldbVersions` arguments. Docs only covered a single version of the Android SDK, LLDB is now bundled with the NDK, and both are no longer available to download from the Android package repositories. Additionally, since the package lists have been updated, some older versions of Android packages may not be bundled. If you depend on older versions of Android packages, we recommend overriding the repo.

  Android packages are now loaded from a repo.json file created by parsing Android repo XML files. The arguments `repoJson` and `repoXmls` have been added to allow overriding the built-in androidenv repo.json with your own. Additionally, license files are now written to allow compatibility with Gradle-based tools, and the `extraLicenses` argument has been added to accept more SDK licenses if your project requires it. See the androidenv documentation for more details.

- The attribute `mpi` is now consistently used to provide a default, system-wide MPI implementation. The default implementation is openmpi, which has been used before by all derivations affects by this change. Note that all packages that have used `mpi ? null` in the input for optional MPI builds, have been changed to the boolean input paramater `useMpi` to enable building with MPI. Building all packages with `mpich` instead of the default `openmpi` can now be achived like this:

  ```nix
  self: super:
  {
    mpi = super.mpich;
  }
  ```

- The Searx module has been updated with the ability to configure the service declaratively and uWSGI integration. The option `services.searx.configFile` has been renamed to [services.searx.settingsFile](options.html#opt-services.searx.settingsFile) for consistency with the new [services.searx.settings](options.html#opt-services.searx.settings). In addition, the `searx` uid and gid reservations have been removed since they were not necessary: the service is now running with a dynamically allocated uid.

- The libinput module has been updated with the ability to configure mouse and touchpad settings separately. The options in `services.xserver.libinput` have been renamed to `services.xserver.libinput.touchpad`, while there is a new `services.xserver.libinput.mouse` for mouse related configuration.

  Since touchpad options no longer apply to all devices, you may want to replicate your touchpad configuration in mouse section.

- ALSA OSS emulation (`sound.enableOSSEmulation`) is now disabled by default.

- Thinkfan as been updated to `1.2.x`, which comes with a new YAML based configuration format. For this reason, several NixOS options of the thinkfan module have been changed to non-backward compatible types. In addition, a new [services.thinkfan.settings](options.html#opt-services.thinkfan.settings) option has been added.

  Please read the [ thinkfan documentation](https://github.com/vmatare/thinkfan#readme) before updating.

- Adobe Flash Player support has been dropped from the tree. In particular, the following packages no longer support it:

  - chromium

  - firefox

  - qt48

  - qt5.qtwebkit

  Additionally, packages flashplayer and hal-flash were removed along with the `services.flashpolicyd` module.

- The `security.rngd` module has been removed. It was disabled by default in 20.09 as it was functionally redundant with krngd in the linux kernel. It is not necessary for any device that the kernel recognises as an hardware RNG, as it will automatically run the krngd task to periodically collect random data from the device and mix it into the kernel\'s RNG.

  The default SMTP port for GitLab has been changed to `25` from its previous default of `465`. If you depended on this default, you should now set the [services.gitlab.smtp.port](options.html#opt-services.gitlab.smtp.port) option.

- The default version of ImageMagick has been updated from 6 to 7. You can use imagemagick6, imagemagick6_light, and imagemagick6Big if you need the older version.

- [services.xserver.videoDrivers](options.html#opt-services.xserver.videoDrivers) no longer uses the deprecated `cirrus` and `vesa` device dependent X drivers by default. It also enables both `amdgpu` and `nouveau` drivers by default now.

- The `kindlegen` package is gone, because it is no longer supported or hosted by Amazon. Sadly, its replacement, Kindle Previewer, has no Linux support. However, there are other ways to generate MOBI files. See [the discussion](https://github.com/NixOS/nixpkgs/issues/96439) for more info.

- The apacheKafka packages are now built with version-matched JREs. Versions 2.6 and above, the ones that recommend it, use jdk11, while versions below remain on jdk8. The NixOS service has been adjusted to start the service using the same version as the package, adjustable with the new [services.apache-kafka.jre](options.html#opt-services.apache-kafka.jre) option. Furthermore, the default list of [services.apache-kafka.jvmOptions](options.html#opt-services.apache-kafka.jvmOptions) have been removed. You should set your own according to the [upstream documentation](https://kafka.apache.org/documentation/#java) for your Kafka version.

- The kodi package has been modified to allow concise addon management. Consider the following configuration from previous releases of NixOS to install kodi, including the kodiPackages.inputstream-adaptive and kodiPackages.vfs-sftp addons:

  ```nix
  {
    environment.systemPackages = [
      pkgs.kodi
    ];

    nixpkgs.config.kodi = {
      enableInputStreamAdaptive = true;
      enableVFSSFTP = true;
    };
  }
  ```

  All Kodi `config` flags have been removed, and as a result the above configuration should now be written as:

  ```nix
  {
    environment.systemPackages = [
      (pkgs.kodi.withPackages (p: with p; [
        inputstream-adaptive
        vfs-sftp
      ]))
    ];
  }
  ```

- `environment.defaultPackages` now includes the nano package. If pkgs.nano is not added to the list, make sure another editor is installed and the `EDITOR` environment variable is set to it. Environment variables can be set using `environment.variables`.

- `services.minio.dataDir` changed type to a list of paths, required for specifiyng multiple data directories for using with erasure coding. Currently, the service doesn\'t enforce nor checks the correct number of paths to correspond to minio requirements.

- All CUDA toolkit versions prior to CUDA 10 have been removed.

- The kbdKeymaps package was removed since dvp and neo are now included in kbd. If you want to use the Programmer Dvorak Keyboard Layout, you have to use `dvorak-programmer` in `console.keyMap` now instead of `dvp`. In `services.xserver.xkbVariant` it\'s still `dvp`.

- The babeld service is now being run as an unprivileged user. To achieve that the module configures `skip-kernel-setup true` and takes care of setting forwarding and rp_filter sysctls by itself as well as for each interface in `services.babeld.interfaces`.

- The `services.zigbee2mqtt.config` option has been renamed to `services.zigbee2mqtt.settings` and now follows [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md).

 The yadm dotfile manager has been updated from 2.x to 3.x, which has new (XDG) default locations for some data/state files. Most yadm commands will fail and print a legacy path warning (which describes how to upgrade/migrate your repository). If you have scripts, daemons, scheduled jobs, shell profiles, etc. that invoke yadm, expect them to fail or misbehave until you perform this migration and prepare accordingly.

- Instead of determining `services.radicale.package` automatically based on `system.stateVersion`, the latest version is always used because old versions are not officially supported.

  Furthermore, Radicale\'s systemd unit was hardened which might break some deployments. In particular, a non-default `filesystem_folder` has to be added to `systemd.services.radicale.serviceConfig.ReadWritePaths` if the deprecated `services.radicale.config` is used.

- In the `security.acme` module, use of `--reuse-key` parameter for Lego has been removed. It was introduced for HKPK, but this security feature is now deprecated. It is a better security practice to rotate key pairs instead of always keeping the same. If you need to keep this parameter, you can add it back using `extraLegoRenewFlags` as an option for the appropriate certificate.

## Other Notable Changes {#sec-release-21.05-notable-changes}

- `stdenv.lib` has been deprecated and will break eval in 21.11. Please use `pkgs.lib` instead. See [\#108938](https://github.com/NixOS/nixpkgs/issues/108938) for details.

- [GNURadio](https://www.gnuradio.org/) has a `pkgs` attribute set, and there\'s a `gnuradio.callPackage` function that extends `pkgs` with a `mkDerivation`, and a `mkDerivationWith`, like Qt5. Now all `gnuradio.pkgs` are defined with `gnuradio.callPackage` and some packages that depend on gnuradio are defined with this as well.

- [Privoxy](https://www.privoxy.org/) has been updated to version 3.0.32 (See [announcement](https://lists.privoxy.org/pipermail/privoxy-announce/2021-February/000007.html)). Compared to the previous release, Privoxy has gained support for HTTPS inspection (still experimental), Brotli decompression, several new filters and lots of bug fixes, including security ones. In addition, the package is now built with compression and external filters support, which were previously disabled.

  Regarding the NixOS module, new options for HTTPS inspection have been added and `services.privoxy.extraConfig` has been replaced by the new [services.privoxy.settings](options.html#opt-services.privoxy.settings) (See [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) for the motivation).

- [Kodi](https://kodi.tv/) has been updated to version 19.1 \"Matrix\". See the [announcement](https://kodi.tv/article/kodi-19-0-matrix-release) for further details.

- The `services.packagekit.backend` option has been removed as it only supported a single setting which would always be the default. Instead new [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) compliant [services.packagekit.settings](options.html#opt-services.packagekit.settings) and [services.packagekit.vendorSettings](options.html#opt-services.packagekit.vendorSettings) options have been introduced.

- [Nginx](https://nginx.org) has been updated to stable version 1.20.0. Now nginx uses the zlib-ng library by default.

- KDE Gear (formerly KDE Applications) is upgraded to 21.04, see its [release notes](https://kde.org/announcements/gear/21.04/) for details.

  The `kdeApplications` package set is now `kdeGear`, in keeping with the new name. The old name remains for compatibility, but it is deprecated.

- [Libreswan](https://libreswan.org/) has been updated to version 4.4. The package now includes example configurations and manual pages by default. The NixOS module has been changed to use the upstream systemd units and write the configuration in the `/etc/ipsec.d/ ` directory. In addition, two new options have been added to specify connection policies ([services.libreswan.policies](options.html#opt-services.libreswan.policies)) and disable send/receive redirects ([services.libreswan.disableRedirects](options.html#opt-services.libreswan.disableRedirects)).

- The Mailman NixOS module (`services.mailman`) has a new option [services.mailman.enablePostfix](options.html#opt-services.mailman.enablePostfix), defaulting to true, that controls integration with Postfix.

  If this option is disabled, default MTA config becomes not set and you should set the options in `services.mailman.settings.mta` according to the desired configuration as described in [Mailman documentation](https://mailman.readthedocs.io/en/latest/src/mailman/docs/mta.html).

- The default-version of `nextcloud` is nextcloud21. Please note that it\'s _not_ possible to upgrade `nextcloud` across multiple major versions! This means that it\'s e.g. not possible to upgrade from nextcloud18 to nextcloud20 in a single deploy and most `20.09` users will have to upgrade to nextcloud20 first.

  The package can be manually upgraded by setting [services.nextcloud.package](options.html#opt-services.nextcloud.package) to nextcloud21.

- The setting [services.redis.bind](options.html#opt-services.redis.bind) defaults to `127.0.0.1` now, making Redis listen on the loopback interface only, and not all public network interfaces.

- NixOS now emits a deprecation warning if systemd\'s `StartLimitInterval` setting is used in a `serviceConfig` section instead of in a `unitConfig`; that setting is deprecated and now undocumented for the service section by systemd upstream, but still effective and somewhat buggy there, which can be confusing. See [\#45785](https://github.com/NixOS/nixpkgs/issues/45785) for details.

  All services should use [systemd.services._name_.startLimitIntervalSec](options.html#opt-systemd.services._name_.startLimitIntervalSec) or `StartLimitIntervalSec` in [systemd.services._name_.unitConfig](options.html#opt-systemd.services._name_.unitConfig) instead.

- The `mediatomb` service declares new options. It also adapts existing options so the configuration generation is now lazy. The existing option `customCfg` (defaults to false), when enabled, stops the service configuration generation completely. It then expects the users to provide their own correct configuration at the right location (whereas the configuration was generated and not used at all before). The new option `transcodingOption` (defaults to no) allows a generated configuration. It makes the mediatomb service pulls the necessary runtime dependencies in the nix store (whereas it was generated with hardcoded values before). The new option `mediaDirectories` allows the users to declare autoscan media directories from their nixos configuration:

  ```nix
  {
    services.mediatomb.mediaDirectories = [
      { path = "/var/lib/mediatomb/pictures"; recursive = false; hidden-files = false; }
      { path = "/var/lib/mediatomb/audio"; recursive = true; hidden-files = false; }
    ];
  }
  ```

- The Unbound DNS resolver service (`services.unbound`) has been refactored to allow reloading, control sockets and to fix startup ordering issues.

  It is now possible to enable a local UNIX control socket for unbound by setting the [services.unbound.localControlSocketPath](options.html#opt-services.unbound.localControlSocketPath) option.

  Previously we just applied a very minimal set of restrictions and trusted unbound to properly drop root privs and capabilities.

  As of this we are (for the most part) just using the upstream example unit file for unbound. The main difference is that we start unbound as `unbound` user with the required capabilities instead of letting unbound do the chroot & uid/gid changes.

  The upstream unit configuration this is based on is a lot stricter with all kinds of permissions then our previous variant. It also came with the default of having the `Type` set to `notify`, therefore we are now also using the `unbound-with-systemd` package here. Unbound will start up, read the configuration files and start listening on the configured ports before systemd will declare the unit `active (running)`. This will likely help with startup order and the occasional race condition during system activation where the DNS service is started but not yet ready to answer queries. Services depending on `nss-lookup.target` or `unbound.service` are now be able to use unbound when those targets have been reached.

  Additionally to the much stricter runtime environment the `/dev/urandom` mount lines we previously had in the code (that randomly failed during the stop-phase) have been removed as systemd will take care of those for us.

  The `preStart` script is now only required if we enabled the trust anchor updates (which are still enabled by default).

  Another benefit of the refactoring is that we can now issue reloads via either `pkill -HUP unbound` and `systemctl reload unbound` to reload the running configuration without taking the daemon offline. A prerequisite of this was that unbound configuration is available on a well known path on the file system. We are using the path `/etc/unbound/unbound.conf` as that is the default in the CLI tooling which in turn enables us to use `unbound-control` without passing a custom configuration location.

  The module has also been reworked to be [RFC 0042](https://github.com/NixOS/rfcs/blob/master/rfcs/0042-config-option.md) compliant. As such, `sevices.unbound.extraConfig` has been removed and replaced by [services.unbound.settings](options.html#opt-services.unbound.settings). `services.unbound.interfaces` has been renamed to `services.unbound.settings.server.interface`.

  `services.unbound.forwardAddresses` and `services.unbound.allowedAccess` have also been changed to use the new settings interface. You can follow the instructions when executing `nixos-rebuild` to upgrade your configuration to use the new interface.

- The `services.dnscrypt-proxy2` module now takes the upstream\'s example configuration and updates it with the user\'s settings. An option has been added to restore the old behaviour if you prefer to declare the configuration from scratch.

- NixOS now defaults to the unified cgroup hierarchy (cgroupsv2). See the [Fedora Article for 31](https://www.redhat.com/sysadmin/fedora-31-control-group-v2) for details on why this is desirable, and how it impacts containers.

  If you want to run containers with a runtime that does not yet support cgroupsv2, you can switch back to the old behaviour by setting [systemd.enableUnifiedCgroupHierarchy](options.html#opt-systemd.enableUnifiedCgroupHierarchy) = `false`; and rebooting.

- PulseAudio was upgraded to 14.0, with changes to the handling of default sinks. See its [release notes](https://www.freedesktop.org/wiki/Software/PulseAudio/Notes/14.0/).

- GNOME users may wish to delete their `~/.config/pulse` due to the changes to stream routing logic. See [PulseAudio bug 832](https://gitlab.freedesktop.org/pulseaudio/pulseaudio/-/issues/832) for more information.

- The zookeeper package does not provide `zooInspector.sh` anymore, as that \"contrib\" has been dropped from upstream releases.

- In the ACME module, the data used to build the hash for the account directory has changed to accomodate new features to reduce account rate limit issues. This will trigger new account creation on the first rebuild following this update. No issues are expected to arise from this, thanks to the new account creation handling.

- [users.users._name_.createHome](options.html#opt-users.users._name_.createHome) now always ensures home directory permissions to be `0700`. Permissions had previously been ignored for already existing home directories, possibly leaving them readable by others. The option\'s description was incorrect regarding ownership management and has been simplified greatly.

- When defining a new user, one of [users.users._name_.isNormalUser](options.html#opt-users.users._name_.isNormalUser) and [users.users._name_.isSystemUser](options.html#opt-users.users._name_.isSystemUser) is now required. This is to prevent accidentally giving a UID above 1000 to system users, which could have unexpected consequences, like running user activation scripts for system users. Note that users defined with an explicit UID below 500 are exempted from this check, as [users.users._name_.isSystemUser](options.html#opt-users.users._name_.isSystemUser) has no effect for those.

- The `security.apparmor` module, for the [AppArmor](https://gitlab.com/apparmor/apparmor/-/wikis/Documentation) Mandatory Access Control system, has been substantialy improved along with related tools, so that module maintainers can now more easily write AppArmor profiles for NixOS. The most notable change on the user-side is the new option [security.apparmor.policies](options.html#opt-security.apparmor.policies), replacing the previous `profiles` option to provide a way to disable a profile and to select whether to confine in enforce mode (default) or in complain mode (see `journalctl -b --grep apparmor`). Security-minded users may also want to enable [security.apparmor.killUnconfinedConfinables](options.html#opt-security.apparmor.killUnconfinedConfinables), at the cost of having some of their processes killed when updating to a NixOS version introducing new AppArmor profiles.

- The GNOME desktop manager once again installs gnome.epiphany by default.

- NixOS now generates empty `/etc/netgroup`. `/etc/netgroup` defines network-wide groups and may affect to setups using NIS.

- Platforms, like `stdenv.hostPlatform`, no longer have a `platform` attribute. It has been (mostly) flattened away:

  - `platform.gcc` is now `gcc`

  - `platform.kernel*` is now `linux-kernel.*`

  Additionally, `platform.kernelArch` moved to the top level as `linuxArch` to match the other `*Arch` variables.

  The `platform` grouping of these things never meant anything, and was just a historial/implementation artifact that was overdue removal.

- `services.restic` now uses a dedicated cache directory for every backup defined in `services.restic.backups`. The old global cache directory, `/root/.cache/restic`, is now unused and can be removed to free up disk space.

- `isync`: The `isync` compatibility wrapper was removed and the Master/Slave terminology has been deprecated and should be replaced with Far/Near in the configuration file.

- The nix-gc service now accepts randomizedDelaySec (default: 0) and persistent (default: true) parameters. By default nix-gc will now run immediately if it would have been triggered at least once during the time when the timer was inactive.

- The `rustPlatform.buildRustPackage` function is split into several hooks: cargoSetupHook to set up vendoring for Cargo-based projects, cargoBuildHook to build a project using Cargo, cargoInstallHook to install a project using Cargo, and cargoCheckHook to run tests in Cargo-based projects. With this change, mixed-language projects can use the relevant hooks within builders other than `buildRustPackage`. However, these changes also required several API changes to `buildRustPackage` itself:

  - The `target` argument was removed. Instead, `buildRustPackage` will always use the same target as the C/C++ compiler that is used.

  - The `cargoParallelTestThreads` argument was removed. Parallel tests are now disabled through `dontUseCargoParallelTests`.

- The `rustPlatform.maturinBuildHook` hook was added. This hook can be used with `buildPythonPackage` to build Python packages that are written in Rust and use Maturin as their build tool.

- Kubernetes has [deprecated docker](https://kubernetes.io/blog/2020/12/02/dont-panic-kubernetes-and-docker/) as container runtime. As a consequence, the Kubernetes module now has support for configuration of custom remote container runtimes and enables containerd by default. Note that containerd is more strict regarding container image OCI-compliance. As an example, images with CMD or ENTRYPOINT defined as strings (not lists) will fail on containerd, while working fine on docker. Please test your setup and container images with containerd prior to upgrading.

- The GitLab module now has support for automatic backups. A schedule can be set with the [services.gitlab.backup.startAt](options.html#opt-services.gitlab.backup.startAt) option.

- Prior to this release, systemd would also read system units from an undocumented `/etc/systemd-mutable/system` path. This path has been dropped from the defaults. That path (or others) can be re-enabled by adding it to the [boot.extraSystemdUnitPaths](options.html#opt-boot.extraSystemdUnitPaths) list.

- PostgreSQL 9.5 is scheduled EOL during the 21.05 life cycle and has been removed.

- [Xfce4](https://www.xfce.org/) relies on GIO/GVfs for userspace virtual filesystem access in applications like [thunar](https://docs.xfce.org/xfce/thunar/) and [gigolo](https://docs.xfce.org/apps/gigolo/). For that to work, the gvfs nixos service is enabled by default, and it can be configured with the specific package that provides GVfs. Until now Xfce4 was setting it to use a lighter version of GVfs (without support for samba). To avoid conflicts with other desktop environments this setting has been dropped. Users that still want it should add the following to their system configuration:

  ```nix
  {
    services.gvfs.package = pkgs.gvfs.override { samba = null; };
  }
  ```

- The newly enabled `systemd-pstore.service` now automatically evacuates crashdumps and panic logs from the persistent storage to `/var/lib/systemd/pstore`. This prevents NVRAM from filling up, which ensures the latest diagnostic data is always stored and alleviates problems with writing new boot configurations.

- Nixpkgs now contains [automatically packaged GNOME Shell extensions](https://github.com/NixOS/nixpkgs/pull/118232) from the [GNOME Extensions](https://extensions.gnome.org/) portal. You can find them, filed by their UUID, under `gnome38Extensions` attribute for GNOME 3.38 and under `gnome40Extensions` for GNOME 40. Finally, the `gnomeExtensions` attribute contains extensions for the latest GNOME Shell version in Nixpkgs, listed under a more human-friendly name. The unqualified attribute scope also contains manually packaged extensions. Note that the automatically packaged extensions are provided for convenience and are not checked or guaranteed to work.

- Erlang/OTP versions older than R21 got dropped. We also dropped the cuter package, as it was purely an example of how to build a package. We also dropped `lfe_1_2` as it could not build with R21+. Moving forward, we expect to only support 3 yearly releases of OTP.
