{ config, lib, pkgs, options }:

with lib;

let
  cfg = config.services.prometheus.exporters.nginxlog;
in {
  port = 9117;
  extraOpts = {
    settings = mkOption {
      type = types.attrs;
      default = {};
      description = ''
        All settings of nginxlog expressed as an Nix attrset.

        Check the official documentation for the corresponding YAML
        settings that can all be used here: https://github.com/martin-helmich/prometheus-nginxlog-exporter

        The `listen` object is already generated by `port`, `listenAddress` and `metricsEndpoint` and
        will be merged with the value of `settings` before writting it as JSON.
      '';
    };

    metricsEndpoint = mkOption {
      type = types.str;
      default = "/metrics";
      description = ''
        Path under which to expose metrics.
      '';
    };
  };

  serviceOpts = let
    listenConfig = {
      listen = {
        port = cfg.port;
        address = cfg.listenAddress;
        metrics_endpoint = cfg.metricsEndpoint;
      };
    };
    completeConfig = pkgs.writeText "nginxlog-exporter.yaml" (builtins.toJSON (lib.recursiveUpdate listenConfig cfg.settings));
  in {
    serviceConfig = {
      ExecStart = ''
        ${pkgs.prometheus-nginxlog-exporter}/bin/prometheus-nginxlog-exporter -config-file ${completeConfig}
      '';
      Restart="always";
      ProtectSystem="full";
    };
  };
}
