{ lib, stdenv, fetchurl, lzip
}:

# Note: this package is used for bootstrapping fetchurl, and thus
# cannot use fetchpatch! All mutable patches (generated by GitHub or
# cgit) that are needed here should be included directly in Nixpkgs as
# files.

stdenv.mkDerivation (rec {
  pname = "ed";
  version = "1.17";

  src = fetchurl {
    url = "mirror://gnu/ed/${pname}-${version}.tar.lz";
    sha256 = "0m2yrkfjjraakxr98nsiakqrn351h99n706x9asgmdi57j43kpki";
  };

  nativeBuildInputs = [ lzip ];

  doCheck = true; # not cross;

  meta = {
    description = "An implementation of the standard Unix editor";

    longDescription = ''
      GNU ed is a line-oriented text editor.  It is used to create,
      display, modify and otherwise manipulate text files, both
      interactively and via shell scripts.  A restricted version of ed,
      red, can only edit files in the current directory and cannot
      execute shell commands.  Ed is the "standard" text editor in the
      sense that it is the original editor for Unix, and thus widely
      available.  For most purposes, however, it is superseded by
      full-screen editors such as GNU Emacs or GNU Moe.
    '';

    license = lib.licenses.gpl3Plus;

    homepage = "https://www.gnu.org/software/ed/";

    maintainers = [ ];
    platforms = lib.platforms.unix;
  };
} // lib.optionalAttrs (stdenv.hostPlatform != stdenv.buildPlatform) {
  # This may be moved above during a stdenv rebuild.
  preConfigure = ''
    configureFlagsArray+=("CC=$CC")
  '';
})
