# This file was generated by go2nix.
{ lib, buildGoPackage, fetchFromGitHub, installShellFiles }:

buildGoPackage rec {
  pname = "machine";
  version = "0.16.1";

  goPackagePath = "github.com/docker/machine";

  src = fetchFromGitHub {
    rev = "v${version}";
    owner = "docker";
    repo = "machine";
    sha256 = "0xxzxi5v7ji9j2k7kxhi0ah91lfa7b9rg3nywgx0lkv8dlgp8kmy";
  };

  nativeBuildInputs = [ installShellFiles ];

  postInstall = ''
    pushd go/src/${goPackagePath}/contrib/completion
    installShellCompletion --bash bash/*
    installShellCompletion --zsh zsh/*
    popd
  '';

  meta = with lib; {
    homepage = "https://docs.docker.com/machine/";
    description = "Docker Machine is a tool that lets you install Docker Engine on virtual hosts, and manage Docker Engine on the hosts";
    license = licenses.asl20;
    maintainers = with maintainers; [ offline tailhook ];
    platforms = platforms.unix;
  };
}
