{lib, stdenv, fetchurl, unzip}:
let
  s = # Generated upstream information
  rec {
    baseName="angelscript";
    version = "2.22.2";
    name="${baseName}-${version}";
    url="http://www.angelcode.com/angelscript/sdk/files/angelscript_${version}.zip";
    sha256 = "1pp853lbnz383ilp9wbgc3wv1dn7lpx3idz8dmzda94rckl7sd43";
  };
in
stdenv.mkDerivation {
  inherit (s) name version;
  nativeBuildInputs = [ unzip ];

  src = fetchurl {
    inherit (s) url sha256;
  };
  preConfigure = ''
    cd angelscript/projects/gnuc
    sed -i makefile -e "s@LOCAL = .*@LOCAL = $out@"
    export SHARED=1
    export VERSION="${s.version}"
    mkdir -p "$out/lib" "$out/bin" "$out/share" "$out/include"
  '';
  postBuild = ''
    rm ../../lib/*
  '';
  postInstall = ''
    mkdir -p "$out/share/docs/angelscript"
    cp -r ../../../docs/* "$out/share/docs/angelscript"
  '';
  meta = {
    inherit (s) version;
    description = "Light-weight scripting library";
    license = lib.licenses.zlib ;
    maintainers = [lib.maintainers.raskin];
    platforms = lib.platforms.linux;
    badPlatforms = [ "aarch64-linux" ];
    downloadPage = "http://www.angelcode.com/angelscript/downloads.html";
    homepage="http://www.angelcode.com/angelscript/";
  };
}
