{ lib, stdenv, fetchurl
, gmp, mpfr
}:

# Note: this package is used for bootstrapping fetchurl, and thus
# cannot use fetchpatch! All mutable patches (generated by GitHub or
# cgit) that are needed here should be included directly in Nixpkgs as
# files.

stdenv.mkDerivation rec {
  pname = "libmpc";
  version = "1.2.1"; # to avoid clash with the MPD client

  src = fetchurl {
    url = "mirror://gnu/mpc/mpc-${version}.tar.gz";
    sha256 = "0n846hqfqvmsmim7qdlms0qr86f1hck19p12nq3g3z2x74n3sl0p";
  };

  buildInputs = [ gmp mpfr ];

  doCheck = true; # not cross;

  meta = {
    description = "Library for multiprecision complex arithmetic with exact rounding";

    longDescription =
      '' GNU MPC is a C library for the arithmetic of complex numbers with
         arbitrarily high precision and correct rounding of the result.  It is
         built upon and follows the same principles as GNU MPFR.
      '';

    homepage = "http://mpc.multiprecision.org/";
    license = lib.licenses.lgpl2Plus;

    platforms = lib.platforms.all;
    maintainers = [ ];
  };
}
