{stdenv, lib, fetchurl, fetchpatch, cmake, zlib, libxml2, eigen, python, cairo, pcre, pkg-config }:

stdenv.mkDerivation rec {
  pname = "openbabel";
  version = "2.4.1";

  src = fetchurl {
    url = "https://github.com/openbabel/openbabel/archive/openbabel-${lib.replaceStrings ["."] ["-"] version}.tar.gz";
    sha256 = "0xm7y859ivq2cp0q08mwshfxm0jq31xkyr4x8s0j6l7khf57yk2r";
  };

  patches = [
    # ARM / AArch64 fixes.
    (fetchpatch {
      url = "https://github.com/openbabel/openbabel/commit/ee11c98a655296550710db1207b294f00e168216.patch";
      sha256 = "0wjqjrkr4pfirzzicdvlyr591vppydk572ix28jd2sagnfnf566g";
    })
  ];

  buildInputs = [ zlib libxml2 eigen python cairo pcre ];

  nativeBuildInputs = [ cmake pkg-config ];

  meta = with lib; {
    description = "A toolbox designed to speak the many languages of chemical data";
    homepage = "http://openbabel.org";
    platforms = platforms.all;
    maintainers = with maintainers; [ danielbarter ];
    license = licenses.gpl2Plus;
  };
}
