{ lib, fetchFromGitLab, buildDunePackage }:

buildDunePackage rec {
  pname = "menhirLib";
  version = "20211012";

  src = fetchFromGitLab {
    domain = "gitlab.inria.fr";
    owner = "fpottier";
    repo = "menhir";
    rev = version;
    sha256 = "08kf5apbv15n2kcr3qhyr3rvsf2lg25ackr3x9kfgiiqc0p3sz40";
  };

  useDune2 = true;

  meta = with lib; {
    homepage = "http://pauillac.inria.fr/~fpottier/menhir/";
    description = "Runtime support library for parsers generated by Menhir";
    longDescription = ''
      Menhir is a LR(1) parser generator for the Objective Caml programming
      language.  That is, Menhir compiles LR(1) grammar specifications down
      to OCaml code.  Menhir was designed and implemented by François Pottier
      and Yann Régis-Gianas.
    '';
    license = with licenses; [ lgpl2Only ];
    maintainers = with maintainers; [ vbgl ];
  };
}
