require 'rbconfig'
require 'rubygems'
require 'rubygems/specification'
require 'fileutils'

# args/settings
out = ENV["out"]
ruby = ARGV[0]
gemfile = ARGV[1]
bundle_path = ARGV[2]
bundler_path = ARGV[3]
paths = ARGV[4].split
groups = ARGV[5].split

# generate binstubs
FileUtils.mkdir_p("#{out}/bin")
paths.each do |path|
  next unless File.directory?("#{path}/nix-support/gem-meta")

  name = File.read("#{path}/nix-support/gem-meta/name")
  executables = File.read("#{path}/nix-support/gem-meta/executables")
    .force_encoding('UTF-8').split
  executables.each do |exe|
    File.open("#{out}/bin/#{exe}", "w") do |f|
      f.write(<<-EOF)
#!#{ruby}
#
# This file was generated by Nix.
#
# The application '#{exe}' is installed as part of a gem, and
# this file is here to facilitate running it.
#

ENV["BUNDLE_GEMFILE"] = #{gemfile.dump}
ENV.delete 'BUNDLE_PATH'
ENV['BUNDLE_FROZEN'] = '1'
ENV['BUNDLE_IGNORE_CONFIG'] = '1'

Gem.paths = { 'GEM_HOME' => #{bundle_path.dump} }

$LOAD_PATH.unshift #{File.join(bundler_path, "/lib").dump}

require 'bundler'
Bundler.setup(#{groups.map(&:dump).join(', ')})

load Gem.bin_path(#{name.dump}, #{exe.dump})
EOF
      FileUtils.chmod("+x", "#{out}/bin/#{exe}")
    end
  end
end
