{ lib, stdenv, fetchFromGitHub, fetchpatch, autoreconfHook, pkg-config, glib, ncurses, libcap_ng }:

stdenv.mkDerivation rec {
  pname = "irqbalance";
  version = "1.8.0";

  src = fetchFromGitHub {
    owner = "irqbalance";
    repo = "irqbalance";
    rev = "v${version}";
    sha256 = "sha256-K+Nv6HqBZb0pwfNV127QDq+suaUD7TTV413S6j8NdUU=";
  };

  patches = [
    # pull pending upstream inclusion fix for ncurses-6.3:
    #  https://github.com/Irqbalance/irqbalance/pull/194
    (fetchpatch {
      name = "ncurses-6.3.patch";
      url = "https://github.com/Irqbalance/irqbalance/commit/f8bdd0e64284d841544fd3ebe22f4652902ba8d2.patch";
      sha256 = "sha256-QJIXr8BiKmn/81suuhNJsBRhY2as19/e480lsp2wd6g=";
    })
  ];

  nativeBuildInputs = [ autoreconfHook pkg-config ];

  buildInputs = [ glib ncurses libcap_ng ];

  LDFLAGS = "-lncurses";

  postInstall =
    ''
      # Systemd service
      mkdir -p $out/lib/systemd/system
      grep -vi "EnvironmentFile" misc/irqbalance.service >$out/lib/systemd/system/irqbalance.service
      substituteInPlace $out/lib/systemd/system/irqbalance.service \
        --replace /usr/sbin/irqbalance $out/bin/irqbalance \
        --replace ' $IRQBALANCE_ARGS' ""
    '';

  meta = with lib; {
    homepage = "https://github.com/Irqbalance/irqbalance";
    changelog = "https://github.com/Irqbalance/irqbalance/releases/tag/v${version}";
    description = "A daemon to help balance the cpu load generated by interrupts across all of a systems cpus";
    license = licenses.gpl2Only;
    platforms = platforms.linux;
    maintainers = with maintainers; [ fortuneteller2k ];
  };
}
