{ lib, stdenv, buildLinux, fetchFromGitHub, ... } @ args:

let
  version = "5.15.2";
  release = "1";
  suffix = "xanmod${release}-tt";
in
buildLinux (args // rec {
  inherit version;
  modDirVersion = "${version}-${suffix}";

  src = fetchFromGitHub {
    owner = "xanmod";
    repo = "linux";
    rev = modDirVersion;
    sha256 = "sha256-3tIwj+4xf/I5srEAqECbfH343J5nzCWViq1ZnidZI24=";
  };

  structuredExtraConfig = with lib.kernel; {
    # removed options
    CFS_BANDWIDTH = lib.mkForce (option no);
    RT_GROUP_SCHED = lib.mkForce (option no);
    SCHED_AUTOGROUP = lib.mkForce (option no);

    # AMD P-state driver
    X86_AMD_PSTATE = yes;

    # Linux RNG framework
    LRNG = yes;

    # Paragon's NTFS3 driver
    NTFS3_FS = module;
    NTFS3_LZX_XPRESS = yes;
    NTFS3_FS_POSIX_ACL = yes;

    # Preemptive Full Tickless Kernel at 500Hz
    SCHED_CORE = lib.mkForce (option no);
    PREEMPT_VOLUNTARY = lib.mkForce no;
    PREEMPT = lib.mkForce yes;
    NO_HZ_FULL = yes;
    HZ_500 = yes;

    # Google's BBRv2 TCP congestion Control
    TCP_CONG_BBR2 = yes;
    DEFAULT_BBR2 = yes;

    # FQ-PIE Packet Scheduling
    NET_SCH_DEFAULT = yes;
    DEFAULT_FQ_PIE = yes;

    # Graysky's additional CPU optimizations
    CC_OPTIMIZE_FOR_PERFORMANCE_O3 = yes;

    # Android Ashmem and Binder IPC Driver as module for Anbox
    ASHMEM = module;
    ANDROID = yes;
    ANDROID_BINDER_IPC = module;
    ANDROID_BINDERFS = module;
    ANDROID_BINDER_DEVICES = freeform "binder,hwbinder,vndbinder";

    # Futex WAIT_MULTIPLE implementation for Wine / Proton Fsync.
    FUTEX = yes;
    FUTEX_PI = yes;
  };

  extraMeta = {
    branch = "5.15-tt";
    maintainers = with lib.maintainers; [ fortuneteller2k lovesegfault ];
    description = "Built with custom settings and new features built to provide a stable, responsive and smooth desktop experience";
    broken = stdenv.isAarch64;
  };
} // (args.argsOverride or { }))
