{ lib, stdenv, fetchurl, ocamlPackages, ncurses, remind }:

stdenv.mkDerivation rec {
  version = "1.4.6";
  pname = "wyrd";

  src = fetchurl {
    url = "http://pessimization.com/software/wyrd/wyrd-${version}.tar.gz";
    sha256 = "0zlrg602q781q8dij62lwdprpfliyy9j1rqfqcz8p2wgndpivddj";
  };

  NIX_CFLAGS_COMPILE = "-DNCURSES_INTERNALS=1";

  preConfigure = ''
    substituteInPlace curses/curses.ml --replace 'pp gcc' "pp $CC"
  '';

  buildInputs = [ ocamlPackages.ocaml ncurses remind ocamlPackages.camlp4 ];

  preferLocalBuild = true;

  meta = with lib; {
    description = "A text-based front-end to Remind";
    longDescription = ''
      Wyrd is a text-based front-end to Remind, a sophisticated
      calendar and alarm program. Remind's power lies in its
      programmability, and Wyrd does not hide this capability behind
      flashy GUI dialogs. Rather, Wyrd is designed to make you more
      efficient at editing your reminder files directly.
    '';
    homepage = "http://pessimization.com/software/wyrd/";
    downloadPage = "http://pessimization.com/software/wyrd/";
    license = licenses.gpl2;
    maintainers = [ maintainers.prikhi ];
    platforms = platforms.linux;
  };
}
