{ stdenv, lib, fetchFromGitHub, makeWrapper }:

stdenv.mkDerivation rec {
  pname = "exploitdb";
  version = "2021-11-23";

  src = fetchFromGitHub {
    owner = "offensive-security";
    repo = pname;
    rev = version;
    sha256 = "sha256-mYElt+KdeyRxr0Ef++/o47IWhPXBFmRIHbnw1UNXfr4=";
  };

  nativeBuildInputs = [ makeWrapper ];

  installPhase = ''
    runHook preInstall
    mkdir -p $out/bin $out/share
    cp --recursive . $out/share/exploitdb
    makeWrapper $out/share/exploitdb/searchsploit $out/bin/searchsploit
    runHook postInstall
  '';

  meta = with lib; {
    homepage = "https://github.com/offensive-security/exploitdb";
    description = "Archive of public exploits and corresponding vulnerable software";
    license = with licenses; [ gpl2Plus gpl3Plus mit ];
    maintainers = with maintainers; [ applePrincess ];
    mainProgram = "searchsploit";
  };
}
