{ buildGoModule
, fetchFromGitHub
, lib
}:

buildGoModule rec {
  pname = "go-cve-search";
  version = "0.1.3";

  src = fetchFromGitHub {
    owner = "s-index";
    repo = pname;
    rev = "v${version}";
    sha256 = "0hbv829daviskwsyp9xjcvl52m22986b2cylf2rldnxw5x8zqdvd";
  };

  vendorSha256 = "0bhxk39ivbkhwjvq6415lax1pzn208b7px1id0d1nry93bk2zynd";

  # Tests requires network access
  doCheck = false;

  meta = with lib; {
    description = "A lightweight CVE search tool";
    longDescription = ''
      go-cve-search is a lightweight tool to search CVE (Common Vulnerabilities
      and Exposures).
    '';
    homepage = "https://github.com/s-index/go-cve-search";
    license = with licenses; [ mit ];
    maintainers = with maintainers; [ fab ];
  };
}
