{ lib
, fetchFromGitHub
, python3
}:

python3.pkgs.buildPythonApplication rec {
  pname = "regexploit";
  version = "1.0.0";

  disabled = python3.pythonOlder "3.8";

  src = fetchFromGitHub {
    owner = "doyensec";
    repo = pname;
    rev = "v${version}";
    sha256 = "0z3fghsyw0ll36in7ihc0qi3gy7mqi6cw1mi8m8c8xb1nlwpfr0y";
  };

  propagatedBuildInputs = with python3.pkgs; [
    pyyaml
  ];

  checkInputs = with python3.pkgs; [
    pytestCheckHook
  ];

  pythonImportsCheck = [ "regexploit" ];

  meta = with lib; {
    description = "Tool to find regular expressions which are vulnerable to ReDoS";
    homepage = "https://github.com/doyensec/regexploit";
    license = with licenses; [ asl20 ];
    maintainers = with maintainers; [ fab ];
  };
}
