{ fetchurl, lib, stdenv, makeWrapper, perl, perlPackages }:


stdenv.mkDerivation rec {
  pname = "amtterm";
  version = "1.6-1";

  buildInputs = with perlPackages; [ perl SOAPLite ];
  nativeBuildInputs = [ makeWrapper ];

  src = fetchurl {
    url = "https://www.kraxel.org/cgit/amtterm/snapshot/${pname}-${version}.tar.gz";
    sha256 = "1jxcsqkag2bxmrnr4m6g88sln1j2d9liqlna57fj8kkc85316vlc";
  };

  makeFlags = [ "prefix=$(out)" "STRIP=" ];

  postInstall =
    "wrapProgram $out/bin/amttool --prefix PERL5LIB : $PERL5LIB";

  meta = with lib;
    { description = "Intel AMT® SoL client + tools";
      homepage = "https://www.kraxel.org/cgit/amtterm/";
      license = licenses.gpl2;
      maintainers = [ maintainers.ehmry ];
      platforms = platforms.linux;
    };
}
