{ stdenv, lib, fetchurl, gtk2, libdv, libjpeg, libpng, libX11, pkg-config, SDL, SDL_gfx
, withMinimal ? true
}:

# TODO:
# - make dependencies optional
# - libpng-apng as alternative to libpng?
# - libXxf86dga support? checking for XF86DGAQueryExtension in -lXxf86dga... no

stdenv.mkDerivation rec {
  pname = "mjpegtools";
  version = "2.1.0";

  src = fetchurl {
    url = "mirror://sourceforge/mjpeg/mjpegtools-${version}.tar.gz";
    sha256 = "01y4xpfdvd4zgv6fmcjny9mr1gbfd4y2i4adp657ydw6fqyi8kw6";
  };

  hardeningDisable = [ "format" ];

  nativeBuildInputs = [ pkg-config ];
  buildInputs = [ libdv libjpeg libpng ]
              ++ lib.optionals (!withMinimal) [ gtk2 libX11 SDL SDL_gfx ];

  NIX_CFLAGS_COMPILE = lib.optionalString (!withMinimal) "-I${SDL.dev}/include/SDL";

  postPatch = ''
    sed -i -e '/ARCHFLAGS=/s:=.*:=:' configure
  '';

  enableParallelBuilding = true;

  outputs = [ "out" "lib" ];

  meta = with lib; {
    description = "A suite of programs for processing MPEG or MJPEG video";
    homepage = "http://mjpeg.sourceforge.net/";
    license = licenses.gpl2;
    platforms = platforms.unix;
    maintainers = with maintainers; [ abbradar ];
  };
}
