"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.printMembers = void 0;
const tsquery_1 = require("@phenomnomnominal/tsquery");
const fs_1 = require("fs");
const ts = require("typescript");
function printMembers(enumName, value, bitwise = false) {
    const content = (0, fs_1.readFileSync)(require.resolve("typescript/lib/typescript.d.ts")).toString();
    const sourceFile = ts.createSourceFile("typescript.d.ts", content, ts.ScriptTarget.ESNext, true, ts.ScriptKind.TS);
    const [enumDeclaration] = (0, tsquery_1.tsquery)(sourceFile, `EnumDeclaration[name.text="${enumName}"]`);
    const set = [];
    for (const member of enumDeclaration.members) {
        if (member.initializer && ts.isNumericLiteral(member.initializer)) {
            const flag = parseInt(member.initializer.text, 10);
            if (bitwise) {
                if ((value & flag) === flag) {
                    set.push([member.name.getText(), flag]);
                }
            }
            else if (value === flag) {
                set.push([member.name.getText(), flag]);
                break;
            }
        }
    }
    set.sort(([, a], [, b]) => a - b);
    console.log(`${enumName} (${value})`);
    for (const [text, flag] of set) {
        console.log(`  ${text} (${flag})`);
    }
}
exports.printMembers = printMembers;
