"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const yargs = require("yargs");
const enum_1 = require("./enum");
yargs.command("$0 <value>", "lookup a value's flags", (yargs) => yargs
    .positional("value", {
    describe: "the numeric value of the combined flags",
    type: "number",
})
    .option("j", { describe: "JsxFlags", type: "boolean" })
    .option("k", { describe: "TokenFlags", type: "boolean" })
    .option("m", { describe: "ModifierFlags", type: "boolean" })
    .option("n", { describe: "NodeFlags", type: "boolean" })
    .option("o", { describe: "ObjectsFlags", type: "boolean" })
    .option("s", { describe: "SymbolFlags", type: "boolean" })
    .option("t", { describe: "TypeFlags", type: "boolean" }), (argv) => (0, enum_1.printMembers)(getEnumName(argv), argv.value, true)).argv;
function getEnumName(argv) {
    if (argv.j) {
        return "JsxFlags";
    }
    if (argv.k) {
        return "TokenFlags";
    }
    if (argv.m) {
        return "ModifierFlags";
    }
    if (argv.n) {
        return "NodeFlags";
    }
    if (argv.o) {
        return "ObjectFlags";
    }
    if (argv.s) {
        return "SymbolFlags";
    }
    return "TypeFlags";
}
