"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _path() {
  const data = _interopRequireDefault(require("path"));

  _path = function () {
    return data;
  };

  return data;
}

function _plugin() {
  const data = require("@parcel/plugin");

  _plugin = function () {
    return data;
  };

  return data;
}

function _pug() {
  const data = _interopRequireDefault(require("pug"));

  _pug = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = new (_plugin().Transformer)({
  async loadConfig({
    config
  }) {
    let configFile = await config.getConfig(['.pugrc', '.pugrc.js', 'pug.config.js']);

    if (configFile) {
      let isJavascript = _path().default.extname(configFile.filePath) === '.js';

      if (isJavascript) {
        config.invalidateOnStartup();
      }

      return configFile.contents;
    }
  },

  async transform({
    asset,
    config
  }) {
    const pugConfig = config !== null && config !== void 0 ? config : {};
    const content = await asset.getCode();

    const render = _pug().default.compile(content, {
      compileDebug: false,
      basedir: _path().default.dirname(asset.filePath),
      filename: asset.filePath,
      ...pugConfig,
      pretty: pugConfig.pretty || false
    });

    for (let filePath of render.dependencies) {
      await asset.invalidateOnFileChange(filePath);
    }

    asset.type = 'html';
    asset.setCode(render(pugConfig.locals));
    return [asset];
  }

});

exports.default = _default;