"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractCssFromStyleNode = extractCssFromStyleNode;
exports.isAmpBoilerplate = isAmpBoilerplate;
exports.isComment = isComment;
exports.isConditionalComment = isConditionalComment;
exports.isEventHandler = isEventHandler;
exports.isStyleNode = isStyleNode;
exports.optionalRequire = optionalRequire;
const ampBoilerplateAttributes = ['amp-boilerplate', 'amp4ads-boilerplate', 'amp4email-boilerplate'];

function isAmpBoilerplate(node) {
  if (!node.attrs) {
    return false;
  }

  for (const attr of ampBoilerplateAttributes) {
    if (attr in node.attrs) {
      return true;
    }
  }

  return false;
}

function isComment(content) {
  return (content || '').trim().startsWith('<!--');
}

function isConditionalComment(content) {
  return (content || '').trim().startsWith('<!--[if');
}

function isStyleNode(node) {
  return node.tag === 'style' && !isAmpBoilerplate(node) && 'content' in node && node.content.length > 0;
}

function extractCssFromStyleNode(node) {
  return Array.isArray(node.content) ? node.content.join(' ') : node.content;
}

function isEventHandler(attributeName) {
  return attributeName && attributeName.slice && attributeName.slice(0, 2).toLowerCase() === 'on' && attributeName.length >= 5;
}

function optionalRequire(moduleName) {
  try {
    return require(moduleName);
  } catch (e) {
    if (e.code === 'MODULE_NOT_FOUND') {
      return null;
    }

    throw e;
  }
}