"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = minifySvg;

var _helpers = require("../helpers");

const svgo = (0, _helpers.optionalRequire)('svgo');
/** Minify SVG with SVGO */

function minifySvg(tree, options, svgoOptions = {}) {
  if (!svgo) return tree;
  tree.match({
    tag: 'svg'
  }, node => {
    let svgStr = tree.render(node, {
      closingSingleTag: 'slash',
      quoteAllAttributes: true
    });
    const result = svgo.optimize(svgStr, svgoOptions);
    node.tag = false;
    node.attrs = {};
    node.content = result.data;
    return node;
  });
  return tree;
}