"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/**
 * Minify HTML in a safe way without breaking anything.
 */

var _default = {
  sortAttributes: false,
  collapseAttributeWhitespace: true,
  collapseBooleanAttributes: {
    amphtml: false
  },
  collapseWhitespace: 'conservative',
  custom: [],
  deduplicateAttributeValues: true,
  mergeScripts: false,
  mergeStyles: false,
  removeUnusedCss: false,
  minifyCss: {
    preset: 'default'
  },
  minifyJs: {},
  minifyJson: {},
  minifySvg: {
    plugins: [{
      name: 'preset-default',
      params: {
        overrides: {
          collapseGroups: false,
          convertShapeToPath: false
        }
      }
    }]
  },
  minifyConditionalComments: false,
  removeRedundantAttributes: false,
  normalizeAttributeValues: true,
  removeEmptyAttributes: true,
  removeComments: 'safe',
  removeAttributeQuotes: false,
  sortAttributesWithLists: 'alphabetical',
  minifyUrls: false,
  removeOptionalTags: false
};
exports.default = _default;