"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _plugin() {
  const data = require("@parcel/plugin");

  _plugin = function () {
    return data;
  };

  return data;
}

function _diagnostic() {
  const data = _interopRequireDefault(require("@parcel/diagnostic"));

  _diagnostic = function () {
    return data;
  };

  return data;
}

function _utils() {
  const data = require("@parcel/utils");

  _utils = function () {
    return data;
  };

  return data;
}

function svgo() {
  const data = _interopRequireWildcard(require("svgo"));

  svgo = function () {
    return data;
  };

  return data;
}

function _path() {
  const data = _interopRequireDefault(require("path"));

  _path = function () {
    return data;
  };

  return data;
}

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = new (_plugin().Optimizer)({
  async loadConfig({
    config
  }) {
    let configFile = await config.getConfig(['svgo.config.js', 'svgo.config.json']);

    if (configFile) {
      let isJavascript = _path().default.extname(configFile.filePath) === '.js';

      if (isJavascript) {
        config.invalidateOnStartup();
      }

      return configFile.contents;
    }
  },

  async optimize({
    bundle,
    contents,
    config
  }) {
    if (!bundle.env.shouldOptimize) {
      return {
        contents
      };
    }

    let code = await (0, _utils().blobToString)(contents);
    let result = svgo().optimize(code, {
      plugins: [{
        name: 'preset-default',
        params: {
          overrides: {
            // Removing ids could break SVG sprites.
            cleanupIDs: false,
            // <style> elements and attributes are already minified before they
            // are re-inserted by the packager.
            minifyStyles: false
          }
        }
      }],
      ...config
    });

    if (result.error != null) {
      throw new (_diagnostic().default)({
        diagnostic: {
          message: result.error
        }
      });
    }

    return {
      contents: result.data
    };
  }

});

exports.default = _default;