"use strict";
const eslint_etc_1 = require("eslint-etc");
const tsutils = require("tsutils");
const ts = require("typescript");
const utils_1 = require("../utils");
const defaultOptions = [];
const rule = utils_1.ruleCreator({
    defaultOptions,
    meta: {
        docs: {
            category: "Best Practices",
            description: "Forbids the use of `const enum`.",
            recommended: false,
        },
        fixable: undefined,
        messages: {
            forbidden: "`const enum` is forbidden.",
        },
        schema: [
            {
                properties: {
                    allowLocal: { type: "boolean" },
                },
                type: "object",
            },
        ],
        type: "problem",
    },
    name: "no-const-enum",
    create: (context, unused) => ({
        TSEnumDeclaration: (node) => {
            const [{ allowLocal = false } = {}] = context.options;
            const { esTreeNodeToTSNodeMap } = eslint_etc_1.getParserServices(context);
            const enumDeclaration = esTreeNodeToTSNodeMap.get(node);
            if (allowLocal &&
                !tsutils.hasModifier(enumDeclaration.modifiers, ts.SyntaxKind.ExportKeyword)) {
                return;
            }
            if (!tsutils.hasModifier(enumDeclaration.modifiers, ts.SyntaxKind.ConstKeyword)) {
                return;
            }
            context.report({
                messageId: "forbidden",
                loc: eslint_etc_1.getLoc(enumDeclaration.name),
            });
        },
    }),
});
module.exports = rule;
