"use strict";
const eslint_etc_1 = require("eslint-etc");
const utils_1 = require("../utils");
const rule = utils_1.ruleCreator({
    defaultOptions: [],
    meta: {
        docs: {
            category: "Best Practices",
            description: "Forbids the use of `enum`.",
            recommended: false,
        },
        fixable: undefined,
        messages: {
            forbidden: "`enum` is forbidden.",
        },
        schema: [],
        type: "problem",
    },
    name: "no-enum",
    create: (context) => ({
        TSEnumDeclaration: (node) => {
            const { esTreeNodeToTSNodeMap } = eslint_etc_1.getParserServices(context);
            const enumDeclaration = esTreeNodeToTSNodeMap.get(node);
            context.report({
                messageId: "forbidden",
                loc: eslint_etc_1.getLoc(enumDeclaration.name),
            });
        },
    }),
});
module.exports = rule;
